/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.dialect.s3.converter.arguments;

import cn.herodotus.oss.dialect.s3.definition.arguments.ArgumentsToBucketConverter;
import cn.herodotus.oss.specification.arguments.multipart.CompleteMultipartUploadArguments;
import cn.herodotus.oss.specification.domain.multipart.PartSummaryDomain;
import com.amazonaws.services.s3.model.CompleteMultipartUploadRequest;
import com.amazonaws.services.s3.model.PartETag;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;

public class ArgumentsToCompleteMultipartUploadRequestConverter
extends ArgumentsToBucketConverter<CompleteMultipartUploadArguments, CompleteMultipartUploadRequest> {
    public CompleteMultipartUploadRequest getInstance(CompleteMultipartUploadArguments arguments) {
        CompleteMultipartUploadRequest request = new CompleteMultipartUploadRequest();
        return request.withBucketName(arguments.getBucketName()).withKey(arguments.getObjectName()).withUploadId(arguments.getUploadId()).withPartETags(this.convert(arguments.getParts()));
    }

    private List<PartETag> convert(List<PartSummaryDomain> attributes) {
        if (CollectionUtils.isNotEmpty(attributes)) {
            return attributes.stream().map(item -> new PartETag(item.getPartNumber(), item.getEtag())).toList();
        }
        return new ArrayList<PartETag>();
    }
}

