/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.dialect.s3.service;

import cn.herodotus.oss.dialect.core.exception.OssServerException;
import cn.herodotus.oss.dialect.s3.definition.pool.S3ClientObjectPool;
import cn.herodotus.oss.dialect.s3.definition.service.BaseS3Service;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.CopyObjectRequest;
import com.amazonaws.services.s3.model.CopyObjectResult;
import com.amazonaws.services.s3.model.DeleteVersionRequest;
import com.amazonaws.services.s3.model.GetObjectMetadataRequest;
import com.amazonaws.services.s3.model.ListNextBatchOfObjectsRequest;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.PutObjectResult;
import com.amazonaws.services.s3.model.RestoreObjectRequest;
import com.amazonaws.services.s3.model.RestoreObjectResult;
import com.amazonaws.services.s3.model.SelectObjectContentRequest;
import com.amazonaws.services.s3.model.SelectObjectContentResult;
import com.amazonaws.services.s3.model.WriteGetObjectResponseRequest;
import com.amazonaws.services.s3.model.WriteGetObjectResponseResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class S3ObjectService
extends BaseS3Service {
    private static final Logger log = LoggerFactory.getLogger(S3ObjectService.class);

    public S3ObjectService(S3ClientObjectPool s3ClientObjectPool) {
        super(s3ClientObjectPool);
    }

    public ObjectMetadata getObjectMetadata(GetObjectMetadataRequest request) {
        String function = "getObjectMetadata";
        AmazonS3 amazonS3 = (AmazonS3)this.getClient();
        try {
            ObjectMetadata objectMetadata = amazonS3.getObjectMetadata(request);
            return objectMetadata;
        }
        catch (AmazonServiceException e) {
            log.error("[Herodotus] |- Amazon S3 catch AmazonServiceException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        finally {
            this.close(amazonS3);
        }
    }

    public PutObjectResult putObject(PutObjectRequest request) {
        String function = "putObject";
        AmazonS3 amazonS3 = (AmazonS3)this.getClient();
        try {
            PutObjectResult putObjectResult = amazonS3.putObject(request);
            return putObjectResult;
        }
        catch (AmazonServiceException e) {
            log.error("[Herodotus] |- Amazon S3 catch AmazonServiceException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        finally {
            this.close(amazonS3);
        }
    }

    public CopyObjectResult copyObject(CopyObjectRequest request) {
        String function = "copyObject";
        AmazonS3 amazonS3 = (AmazonS3)this.getClient();
        try {
            CopyObjectResult copyObjectResult = amazonS3.copyObject(request);
            return copyObjectResult;
        }
        catch (AmazonServiceException e) {
            log.error("[Herodotus] |- Amazon S3 catch AmazonServiceException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        finally {
            this.close(amazonS3);
        }
    }

    public void deleteVersion(DeleteVersionRequest request) {
        String function = "deleteObjects";
        AmazonS3 amazonS3 = (AmazonS3)this.getClient();
        try {
            amazonS3.deleteVersion(request);
        }
        catch (AmazonServiceException e) {
            log.error("[Herodotus] |- Amazon S3 catch AmazonServiceException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        finally {
            this.close(amazonS3);
        }
    }

    public RestoreObjectResult restoreObject(RestoreObjectRequest request) {
        String function = "restoreObjectV2";
        AmazonS3 amazonS3 = (AmazonS3)this.getClient();
        try {
            RestoreObjectResult restoreObjectResult = amazonS3.restoreObjectV2(request);
            return restoreObjectResult;
        }
        catch (AmazonServiceException e) {
            log.error("[Herodotus] |- Amazon S3 catch AmazonServiceException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        finally {
            this.close(amazonS3);
        }
    }

    public SelectObjectContentResult selectObjectContent(SelectObjectContentRequest request) {
        String function = "selectObjectContent";
        AmazonS3 amazonS3 = (AmazonS3)this.getClient();
        try {
            SelectObjectContentResult selectObjectContentResult = amazonS3.selectObjectContent(request);
            return selectObjectContentResult;
        }
        catch (AmazonServiceException e) {
            log.error("[Herodotus] |- Amazon S3 catch AmazonServiceException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        finally {
            this.close(amazonS3);
        }
    }

    public WriteGetObjectResponseResult writeGetObjectResponse(WriteGetObjectResponseRequest request) {
        String function = "writeGetObjectResponse";
        AmazonS3 amazonS3 = (AmazonS3)this.getClient();
        try {
            WriteGetObjectResponseResult writeGetObjectResponseResult = amazonS3.writeGetObjectResponse(request);
            return writeGetObjectResponseResult;
        }
        catch (AmazonServiceException e) {
            log.error("[Herodotus] |- Amazon S3 catch AmazonServiceException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        finally {
            this.close(amazonS3);
        }
    }

    public ObjectListing listNextBatchOfObjects(ListNextBatchOfObjectsRequest request) {
        String function = "listNextBatchOfObjects";
        AmazonS3 amazonS3 = (AmazonS3)this.getClient();
        try {
            ObjectListing objectListing = amazonS3.listNextBatchOfObjects(request);
            return objectListing;
        }
        catch (AmazonServiceException e) {
            log.error("[Herodotus] |- Amazon S3 catch AmazonServiceException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        finally {
            this.close(amazonS3);
        }
    }
}

