/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.dialect.s3.service;

import cn.herodotus.oss.dialect.core.exception.OssServerException;
import cn.herodotus.oss.dialect.s3.definition.pool.S3ClientObjectPool;
import cn.herodotus.oss.dialect.s3.definition.service.BaseS3Service;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.BucketLifecycleConfiguration;
import com.amazonaws.services.s3.model.DeleteBucketLifecycleConfigurationRequest;
import com.amazonaws.services.s3.model.GetBucketLifecycleConfigurationRequest;
import com.amazonaws.services.s3.model.SetBucketLifecycleConfigurationRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class S3BucketLifecycleConfigurationService
extends BaseS3Service {
    private static final Logger log = LoggerFactory.getLogger(S3BucketLifecycleConfigurationService.class);

    public S3BucketLifecycleConfigurationService(S3ClientObjectPool s3ClientObjectPool) {
        super(s3ClientObjectPool);
    }

    public void deleteBucketLifecycleConfiguration(DeleteBucketLifecycleConfigurationRequest request) {
        String function = "deleteBucketLifecycleConfiguration";
        AmazonS3 amazonS3 = (AmazonS3)this.getClient();
        try {
            amazonS3.deleteBucketLifecycleConfiguration(request);
        }
        catch (AmazonServiceException e) {
            log.error("[Herodotus] |- Amazon S3 catch AmazonServiceException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        finally {
            this.close(amazonS3);
        }
    }

    public BucketLifecycleConfiguration getBucketLifecycleConfiguration(GetBucketLifecycleConfigurationRequest request) {
        String function = "getBucketLifecycleConfiguration";
        AmazonS3 amazonS3 = (AmazonS3)this.getClient();
        try {
            BucketLifecycleConfiguration bucketLifecycleConfiguration = amazonS3.getBucketLifecycleConfiguration(request);
            return bucketLifecycleConfiguration;
        }
        catch (AmazonServiceException e) {
            log.error("[Herodotus] |- Amazon S3 catch AmazonServiceException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        finally {
            this.close(amazonS3);
        }
    }

    public void setBucketLifecycleConfiguration(SetBucketLifecycleConfigurationRequest request) {
        String function = "setBucketLifecycleConfiguration";
        AmazonS3 amazonS3 = (AmazonS3)this.getClient();
        try {
            amazonS3.setBucketLifecycleConfiguration(request);
        }
        catch (AmazonServiceException e) {
            log.error("[Herodotus] |- Amazon S3 catch AmazonServiceException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        finally {
            this.close(amazonS3);
        }
    }
}

