/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.dialect.s3.repository;

import cn.herodotus.engine.assistant.definition.support.AbstractObjectPool;
import cn.herodotus.oss.dialect.core.exception.OssServerException;
import cn.herodotus.oss.dialect.s3.converter.arguments.ArgumentsToAbortMultipartUploadRequestConverter;
import cn.herodotus.oss.dialect.s3.converter.arguments.ArgumentsToCompleteMultipartUploadRequestConverter;
import cn.herodotus.oss.dialect.s3.converter.arguments.ArgumentsToCopyPartRequestConverter;
import cn.herodotus.oss.dialect.s3.converter.arguments.ArgumentsToInitiateMultipartUploadRequestConverter;
import cn.herodotus.oss.dialect.s3.converter.arguments.ArgumentsToListMultipartUploadsRequest;
import cn.herodotus.oss.dialect.s3.converter.arguments.ArgumentsToListPartsRequestConverter;
import cn.herodotus.oss.dialect.s3.converter.arguments.ArgumentsToUploadPartRequestConverter;
import cn.herodotus.oss.dialect.s3.converter.domain.CompleteMultipartUploadResultToDomainConverter;
import cn.herodotus.oss.dialect.s3.converter.domain.CopyPartResultToDomainConverter;
import cn.herodotus.oss.dialect.s3.converter.domain.InitiateMultipartUploadResultToDomainConverter;
import cn.herodotus.oss.dialect.s3.converter.domain.MultipartUploadListingToDomainConverter;
import cn.herodotus.oss.dialect.s3.converter.domain.PartListingToDomainConverter;
import cn.herodotus.oss.dialect.s3.converter.domain.UploadPartResultToDomainConverter;
import cn.herodotus.oss.dialect.s3.definition.service.BaseS3Service;
import cn.herodotus.oss.specification.arguments.multipart.AbortMultipartUploadArguments;
import cn.herodotus.oss.specification.arguments.multipart.CompleteMultipartUploadArguments;
import cn.herodotus.oss.specification.arguments.multipart.InitiateMultipartUploadArguments;
import cn.herodotus.oss.specification.arguments.multipart.ListMultipartUploadsArguments;
import cn.herodotus.oss.specification.arguments.multipart.ListPartsArguments;
import cn.herodotus.oss.specification.arguments.multipart.UploadPartArguments;
import cn.herodotus.oss.specification.arguments.multipart.UploadPartCopyArguments;
import cn.herodotus.oss.specification.core.repository.OssMultipartUploadRepository;
import cn.herodotus.oss.specification.domain.multipart.AbortMultipartUploadDomain;
import cn.herodotus.oss.specification.domain.multipart.CompleteMultipartUploadDomain;
import cn.herodotus.oss.specification.domain.multipart.InitiateMultipartUploadDomain;
import cn.herodotus.oss.specification.domain.multipart.ListMultipartUploadsDomain;
import cn.herodotus.oss.specification.domain.multipart.ListPartsDomain;
import cn.herodotus.oss.specification.domain.multipart.UploadPartCopyDomain;
import cn.herodotus.oss.specification.domain.multipart.UploadPartDomain;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.AbortMultipartUploadRequest;
import com.amazonaws.services.s3.model.CompleteMultipartUploadRequest;
import com.amazonaws.services.s3.model.CompleteMultipartUploadResult;
import com.amazonaws.services.s3.model.CopyPartRequest;
import com.amazonaws.services.s3.model.CopyPartResult;
import com.amazonaws.services.s3.model.InitiateMultipartUploadRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadResult;
import com.amazonaws.services.s3.model.ListMultipartUploadsRequest;
import com.amazonaws.services.s3.model.ListPartsRequest;
import com.amazonaws.services.s3.model.MultipartUploadListing;
import com.amazonaws.services.s3.model.PartListing;
import com.amazonaws.services.s3.model.UploadPartRequest;
import com.amazonaws.services.s3.model.UploadPartResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3MultipartUploadRepository
extends BaseS3Service
implements OssMultipartUploadRepository {
    private static final Logger log = LoggerFactory.getLogger(S3MultipartUploadRepository.class);

    public S3MultipartUploadRepository(AbstractObjectPool<AmazonS3> ossClientObjectPool) {
        super(ossClientObjectPool);
    }

    public InitiateMultipartUploadDomain initiateMultipartUpload(InitiateMultipartUploadArguments arguments) {
        String function = "initiateMultipartUpload";
        ArgumentsToInitiateMultipartUploadRequestConverter toRequest = new ArgumentsToInitiateMultipartUploadRequestConverter();
        InitiateMultipartUploadResultToDomainConverter toDomain = new InitiateMultipartUploadResultToDomainConverter();
        AmazonS3 client = (AmazonS3)this.getClient();
        try {
            InitiateMultipartUploadResult result = client.initiateMultipartUpload((InitiateMultipartUploadRequest)toRequest.convert(arguments));
            InitiateMultipartUploadDomain initiateMultipartUploadDomain = (InitiateMultipartUploadDomain)toDomain.convert(result);
            return initiateMultipartUploadDomain;
        }
        catch (AmazonServiceException e) {
            log.error("[Herodotus] |- Amazon S3 catch AmazonServiceException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        finally {
            this.close(client);
        }
    }

    public UploadPartDomain uploadPart(UploadPartArguments arguments) {
        String function = "uploadPart";
        ArgumentsToUploadPartRequestConverter toRequest = new ArgumentsToUploadPartRequestConverter();
        UploadPartResultToDomainConverter toDomain = new UploadPartResultToDomainConverter();
        AmazonS3 client = (AmazonS3)this.getClient();
        try {
            UploadPartResult result = client.uploadPart((UploadPartRequest)toRequest.convert(arguments));
            UploadPartDomain uploadPartDomain = (UploadPartDomain)toDomain.convert(result);
            return uploadPartDomain;
        }
        catch (AmazonServiceException e) {
            log.error("[Herodotus] |- Amazon S3 catch AmazonServiceException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        finally {
            this.close(client);
        }
    }

    public UploadPartCopyDomain uploadPartCopy(UploadPartCopyArguments arguments) {
        String function = "uploadPartCopy";
        ArgumentsToCopyPartRequestConverter toRequest = new ArgumentsToCopyPartRequestConverter();
        CopyPartResultToDomainConverter toDomain = new CopyPartResultToDomainConverter();
        AmazonS3 client = (AmazonS3)this.getClient();
        try {
            CopyPartResult result = client.copyPart((CopyPartRequest)toRequest.convert(arguments));
            UploadPartCopyDomain uploadPartCopyDomain = (UploadPartCopyDomain)toDomain.convert(result);
            return uploadPartCopyDomain;
        }
        catch (AmazonServiceException e) {
            log.error("[Herodotus] |- Amazon S3 catch AmazonServiceException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        finally {
            this.close(client);
        }
    }

    public CompleteMultipartUploadDomain completeMultipartUpload(CompleteMultipartUploadArguments arguments) {
        String function = "completeMultipartUpload";
        ArgumentsToCompleteMultipartUploadRequestConverter toRequest = new ArgumentsToCompleteMultipartUploadRequestConverter();
        CompleteMultipartUploadResultToDomainConverter toDomain = new CompleteMultipartUploadResultToDomainConverter();
        AmazonS3 client = (AmazonS3)this.getClient();
        try {
            CompleteMultipartUploadResult result = client.completeMultipartUpload((CompleteMultipartUploadRequest)toRequest.convert(arguments));
            CompleteMultipartUploadDomain completeMultipartUploadDomain = (CompleteMultipartUploadDomain)toDomain.convert(result);
            return completeMultipartUploadDomain;
        }
        catch (AmazonServiceException e) {
            log.error("[Herodotus] |- Amazon S3 catch AmazonServiceException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        finally {
            this.close(client);
        }
    }

    public AbortMultipartUploadDomain abortMultipartUpload(AbortMultipartUploadArguments arguments) {
        String function = "abortMultipartUpload";
        ArgumentsToAbortMultipartUploadRequestConverter toRequest = new ArgumentsToAbortMultipartUploadRequestConverter();
        AmazonS3 client = (AmazonS3)this.getClient();
        try {
            client.abortMultipartUpload((AbortMultipartUploadRequest)toRequest.convert(arguments));
            AbortMultipartUploadDomain domain = new AbortMultipartUploadDomain();
            domain.setUploadId(arguments.getUploadId());
            domain.setBucketName(arguments.getBucketName());
            domain.setObjectName(arguments.getObjectName());
            AbortMultipartUploadDomain abortMultipartUploadDomain = domain;
            return abortMultipartUploadDomain;
        }
        catch (AmazonServiceException e) {
            log.error("[Herodotus] |- Amazon S3 catch AmazonServiceException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        finally {
            this.close(client);
        }
    }

    public ListPartsDomain listParts(ListPartsArguments arguments) {
        String function = "listParts";
        ArgumentsToListPartsRequestConverter toRequest = new ArgumentsToListPartsRequestConverter();
        PartListingToDomainConverter toDomain = new PartListingToDomainConverter();
        AmazonS3 client = (AmazonS3)this.getClient();
        try {
            PartListing partListing = client.listParts((ListPartsRequest)toRequest.convert(arguments));
            ListPartsDomain listPartsDomain = (ListPartsDomain)toDomain.convert(partListing);
            return listPartsDomain;
        }
        catch (AmazonServiceException e) {
            log.error("[Herodotus] |- Amazon S3 catch AmazonServiceException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        finally {
            this.close(client);
        }
    }

    public ListMultipartUploadsDomain listMultipartUploads(ListMultipartUploadsArguments arguments) {
        String function = "listMultipartUploads";
        ArgumentsToListMultipartUploadsRequest toRequest = new ArgumentsToListMultipartUploadsRequest();
        MultipartUploadListingToDomainConverter toDomain = new MultipartUploadListingToDomainConverter();
        AmazonS3 client = (AmazonS3)this.getClient();
        try {
            MultipartUploadListing multipartUploadListing = client.listMultipartUploads((ListMultipartUploadsRequest)toRequest.convert(arguments));
            ListMultipartUploadsDomain listMultipartUploadsDomain = (ListMultipartUploadsDomain)toDomain.convert(multipartUploadListing);
            return listMultipartUploadsDomain;
        }
        catch (AmazonServiceException e) {
            log.error("[Herodotus] |- Amazon S3 catch AmazonServiceException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        finally {
            this.close(client);
        }
    }
}

