/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.dialect.s3.converter.domain;

import cn.herodotus.oss.dialect.s3.converter.domain.OwnerToDomainConverter;
import cn.herodotus.oss.specification.domain.base.OwnerDomain;
import cn.herodotus.oss.specification.domain.multipart.UploadDomain;
import com.amazonaws.services.s3.model.MultipartUpload;
import com.amazonaws.services.s3.model.Owner;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.core.convert.converter.Converter;

public class MultipartUploadToDomainConverter
implements Converter<List<MultipartUpload>, List<UploadDomain>> {
    private final Converter<Owner, OwnerDomain> toAttribute = new OwnerToDomainConverter();

    public List<UploadDomain> convert(List<MultipartUpload> source) {
        if (CollectionUtils.isNotEmpty(source)) {
            return source.stream().map(this::convert).toList();
        }
        return new ArrayList<UploadDomain>();
    }

    private UploadDomain convert(MultipartUpload source) {
        UploadDomain domain = new UploadDomain();
        domain.setKey(source.getKey());
        domain.setUploadId(source.getUploadId());
        domain.setOwner((OwnerDomain)this.toAttribute.convert((Object)source.getOwner()));
        domain.setInitiator((OwnerDomain)this.toAttribute.convert((Object)source.getInitiator()));
        domain.setStorageClass(source.getStorageClass());
        domain.setInitiated(source.getInitiated());
        return domain;
    }
}

