/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.dialect.s3.service;

import cn.herodotus.oss.dialect.core.exception.OssServerException;
import cn.herodotus.oss.dialect.s3.definition.pool.S3ClientObjectPool;
import cn.herodotus.oss.dialect.s3.definition.service.BaseS3Service;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.BucketTaggingConfiguration;
import com.amazonaws.services.s3.model.DeleteBucketTaggingConfigurationRequest;
import com.amazonaws.services.s3.model.GetBucketTaggingConfigurationRequest;
import com.amazonaws.services.s3.model.SetBucketTaggingConfigurationRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class S3BucketTaggingConfigurationService
extends BaseS3Service {
    private static final Logger log = LoggerFactory.getLogger(S3BucketTaggingConfigurationService.class);

    public S3BucketTaggingConfigurationService(S3ClientObjectPool s3ClientObjectPool) {
        super(s3ClientObjectPool);
    }

    public void deleteBucketTaggingConfiguration(DeleteBucketTaggingConfigurationRequest request) {
        String function = "deleteBucketTaggingConfiguration";
        AmazonS3 amazonS3 = (AmazonS3)this.getClient();
        try {
            amazonS3.deleteBucketTaggingConfiguration(request);
        }
        catch (AmazonServiceException e) {
            log.error("[Herodotus] |- Amazon S3 catch AmazonServiceException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        finally {
            this.close(amazonS3);
        }
    }

    public BucketTaggingConfiguration getBucketTaggingConfiguration(GetBucketTaggingConfigurationRequest request) {
        String function = "getBucketTaggingConfiguration";
        AmazonS3 amazonS3 = (AmazonS3)this.getClient();
        try {
            BucketTaggingConfiguration bucketTaggingConfiguration = amazonS3.getBucketTaggingConfiguration(request);
            return bucketTaggingConfiguration;
        }
        catch (AmazonServiceException e) {
            log.error("[Herodotus] |- Amazon S3 catch AmazonServiceException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        finally {
            this.close(amazonS3);
        }
    }

    public void setBucketTaggingConfiguration(SetBucketTaggingConfigurationRequest request) {
        String function = "setBucketTaggingConfiguration";
        AmazonS3 amazonS3 = (AmazonS3)this.getClient();
        try {
            amazonS3.setBucketTaggingConfiguration(request);
        }
        catch (AmazonServiceException e) {
            log.error("[Herodotus] |- Amazon S3 catch AmazonServiceException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        finally {
            this.close(amazonS3);
        }
    }
}

