/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.dialect.s3.repository;

import cn.herodotus.engine.assistant.definition.support.AbstractObjectPool;
import cn.herodotus.oss.dialect.core.exception.OssServerException;
import cn.herodotus.oss.dialect.core.utils.ConverterUtils;
import cn.herodotus.oss.dialect.s3.converter.arguments.ArgumentsToCreateBucketRequestConverter;
import cn.herodotus.oss.dialect.s3.converter.arguments.ArgumentsToDeleteBucketRequestConverter;
import cn.herodotus.oss.dialect.s3.converter.domain.BucketToDomainConverter;
import cn.herodotus.oss.dialect.s3.definition.service.BaseS3Service;
import cn.herodotus.oss.specification.arguments.bucket.CreateBucketArguments;
import cn.herodotus.oss.specification.arguments.bucket.DeleteBucketArguments;
import cn.herodotus.oss.specification.core.repository.OssBucketRepository;
import cn.herodotus.oss.specification.domain.bucket.BucketDomain;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.CreateBucketRequest;
import com.amazonaws.services.s3.model.DeleteBucketRequest;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.convert.converter.Converter;
import org.springframework.stereotype.Service;

@Service
public class S3BucketRepository
extends BaseS3Service
implements OssBucketRepository {
    private static final Logger log = LoggerFactory.getLogger(S3BucketRepository.class);

    public S3BucketRepository(AbstractObjectPool<AmazonS3> ossClientObjectPool) {
        super(ossClientObjectPool);
    }

    public boolean doesBucketExist(String bucketName) {
        String function = "doesBucketExistV2";
        AmazonS3 client = (AmazonS3)this.getClient();
        try {
            boolean bl = client.doesBucketExistV2(bucketName);
            return bl;
        }
        catch (AmazonServiceException e) {
            log.error("[Herodotus] |- Amazon S3 catch AmazonServiceException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        finally {
            this.close(client);
        }
    }

    public List<BucketDomain> listBuckets() {
        String function = "listBuckets";
        AmazonS3 client = (AmazonS3)this.getClient();
        try {
            List list = ConverterUtils.toDomains((List)client.listBuckets(), (Converter)new BucketToDomainConverter());
            return list;
        }
        catch (AmazonServiceException e) {
            log.error("[Herodotus] |- Amazon S3 catch AmazonServiceException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        finally {
            this.close(client);
        }
    }

    public BucketDomain createBucket(String bucketName) {
        String function = "createBucket";
        AmazonS3 client = (AmazonS3)this.getClient();
        try {
            BucketDomain bucketDomain = (BucketDomain)ConverterUtils.toDomain((Object)client.createBucket(bucketName), (Converter)new BucketToDomainConverter());
            return bucketDomain;
        }
        catch (AmazonServiceException e) {
            log.error("[Herodotus] |- Amazon S3 catch AmazonServiceException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        finally {
            this.close(client);
        }
    }

    public BucketDomain createBucket(CreateBucketArguments arguments) {
        String function = "createBucket";
        AmazonS3 client = (AmazonS3)this.getClient();
        try {
            ArgumentsToCreateBucketRequestConverter toRequest = new ArgumentsToCreateBucketRequestConverter();
            BucketDomain bucketDomain = (BucketDomain)ConverterUtils.toDomain((Object)client.createBucket((CreateBucketRequest)toRequest.convert(arguments)), (Converter)new BucketToDomainConverter());
            return bucketDomain;
        }
        catch (AmazonServiceException e) {
            log.error("[Herodotus] |- Amazon S3 catch AmazonServiceException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        finally {
            this.close(client);
        }
    }

    public void deleteBucket(String bucketName) {
        String function = "deleteBucket";
        AmazonS3 client = (AmazonS3)this.getClient();
        try {
            client.deleteBucket(bucketName);
        }
        catch (AmazonServiceException e) {
            log.error("[Herodotus] |- Amazon S3 catch AmazonServiceException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        finally {
            this.close(client);
        }
    }

    public void deleteBucket(DeleteBucketArguments arguments) {
        String function = "deleteBucket";
        AmazonS3 client = (AmazonS3)this.getClient();
        try {
            ArgumentsToDeleteBucketRequestConverter toRequest = new ArgumentsToDeleteBucketRequestConverter();
            client.deleteBucket((DeleteBucketRequest)toRequest.convert(arguments));
        }
        catch (AmazonServiceException e) {
            log.error("[Herodotus] |- Amazon S3 catch AmazonServiceException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        finally {
            this.close(client);
        }
    }
}

