/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.dialect.s3.service;

import cn.herodotus.oss.dialect.core.exception.OssServerException;
import cn.herodotus.oss.dialect.s3.definition.pool.S3ClientObjectPool;
import cn.herodotus.oss.dialect.s3.definition.service.BaseS3Service;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.DeleteBucketOwnershipControlsRequest;
import com.amazonaws.services.s3.model.DeleteBucketOwnershipControlsResult;
import com.amazonaws.services.s3.model.GetBucketOwnershipControlsRequest;
import com.amazonaws.services.s3.model.GetBucketOwnershipControlsResult;
import com.amazonaws.services.s3.model.SetBucketOwnershipControlsRequest;
import com.amazonaws.services.s3.model.SetBucketOwnershipControlsResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class S3BucketOwnershipControlsService
extends BaseS3Service {
    private static final Logger log = LoggerFactory.getLogger(S3BucketOwnershipControlsService.class);

    public S3BucketOwnershipControlsService(S3ClientObjectPool s3ClientObjectPool) {
        super(s3ClientObjectPool);
    }

    public DeleteBucketOwnershipControlsResult deleteBucketOwnershipControls(DeleteBucketOwnershipControlsRequest request) {
        String function = "deleteBucketOwnershipControls";
        AmazonS3 amazonS3 = (AmazonS3)this.getClient();
        try {
            DeleteBucketOwnershipControlsResult deleteBucketOwnershipControlsResult = amazonS3.deleteBucketOwnershipControls(request);
            return deleteBucketOwnershipControlsResult;
        }
        catch (AmazonServiceException e) {
            log.error("[Herodotus] |- Amazon S3 catch AmazonServiceException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        finally {
            this.close(amazonS3);
        }
    }

    public GetBucketOwnershipControlsResult getBucketOwnershipControls(GetBucketOwnershipControlsRequest request) {
        String function = "getBucketOwnershipControls";
        AmazonS3 amazonS3 = (AmazonS3)this.getClient();
        try {
            GetBucketOwnershipControlsResult getBucketOwnershipControlsResult = amazonS3.getBucketOwnershipControls(request);
            return getBucketOwnershipControlsResult;
        }
        catch (AmazonServiceException e) {
            log.error("[Herodotus] |- Amazon S3 catch AmazonServiceException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        finally {
            this.close(amazonS3);
        }
    }

    public SetBucketOwnershipControlsResult setBucketOwnershipControls(SetBucketOwnershipControlsRequest request) {
        String function = "setBucketOwnershipControls";
        AmazonS3 amazonS3 = (AmazonS3)this.getClient();
        try {
            SetBucketOwnershipControlsResult setBucketOwnershipControlsResult = amazonS3.setBucketOwnershipControls(request);
            return setBucketOwnershipControlsResult;
        }
        catch (AmazonServiceException e) {
            log.error("[Herodotus] |- Amazon S3 catch AmazonServiceException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        finally {
            this.close(amazonS3);
        }
    }
}

