/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.dialect.s3.converter.domain;

import cn.herodotus.oss.specification.domain.multipart.PartSummaryDomain;
import com.amazonaws.services.s3.model.PartSummary;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.core.convert.converter.Converter;

public class PartSummaryToDomainConverter
implements Converter<List<PartSummary>, List<PartSummaryDomain>> {
    public List<PartSummaryDomain> convert(List<PartSummary> source) {
        if (CollectionUtils.isNotEmpty(source)) {
            return source.stream().map(this::convert).toList();
        }
        return new ArrayList<PartSummaryDomain>();
    }

    private PartSummaryDomain convert(PartSummary source) {
        PartSummaryDomain domain = new PartSummaryDomain();
        domain.setPartSize(source.getSize());
        domain.setLastModifiedDate(source.getLastModified());
        domain.setPartNumber(source.getPartNumber());
        domain.setEtag(source.getETag());
        return domain;
    }
}

