/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.dialect.s3.service;

import cn.herodotus.oss.dialect.core.exception.OssServerException;
import cn.herodotus.oss.dialect.s3.definition.pool.S3ClientObjectPool;
import cn.herodotus.oss.dialect.s3.definition.service.BaseS3Service;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.DeleteObjectTaggingRequest;
import com.amazonaws.services.s3.model.DeleteObjectTaggingResult;
import com.amazonaws.services.s3.model.GetObjectTaggingRequest;
import com.amazonaws.services.s3.model.GetObjectTaggingResult;
import com.amazonaws.services.s3.model.SetObjectTaggingRequest;
import com.amazonaws.services.s3.model.SetObjectTaggingResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3ObjectTaggingService
extends BaseS3Service {
    private static final Logger log = LoggerFactory.getLogger(S3ObjectTaggingService.class);

    public S3ObjectTaggingService(S3ClientObjectPool s3ClientObjectPool) {
        super(s3ClientObjectPool);
    }

    public DeleteObjectTaggingResult deleteObjectTagging(DeleteObjectTaggingRequest request) {
        String function = "deleteObjectTagging";
        AmazonS3 amazonS3 = (AmazonS3)this.getClient();
        try {
            DeleteObjectTaggingResult deleteObjectTaggingResult = amazonS3.deleteObjectTagging(request);
            return deleteObjectTaggingResult;
        }
        catch (AmazonServiceException e) {
            log.error("[Herodotus] |- Amazon S3 catch AmazonServiceException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        finally {
            this.close(amazonS3);
        }
    }

    public GetObjectTaggingResult getObjectTagging(GetObjectTaggingRequest request) {
        String function = "getObjectTagging";
        AmazonS3 amazonS3 = (AmazonS3)this.getClient();
        try {
            GetObjectTaggingResult getObjectTaggingResult = amazonS3.getObjectTagging(request);
            return getObjectTaggingResult;
        }
        catch (AmazonServiceException e) {
            log.error("[Herodotus] |- Amazon S3 catch AmazonServiceException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        finally {
            this.close(amazonS3);
        }
    }

    public SetObjectTaggingResult setObjectTagging(SetObjectTaggingRequest request) {
        String function = "setObjectTagging";
        AmazonS3 amazonS3 = (AmazonS3)this.getClient();
        try {
            SetObjectTaggingResult setObjectTaggingResult = amazonS3.setObjectTagging(request);
            return setObjectTaggingResult;
        }
        catch (AmazonServiceException e) {
            log.error("[Herodotus] |- Amazon S3 catch AmazonServiceException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        finally {
            this.close(amazonS3);
        }
    }
}

