/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.dialect.s3.service;

import cn.herodotus.oss.dialect.core.exception.OssServerException;
import cn.herodotus.oss.dialect.s3.definition.pool.S3ClientObjectPool;
import cn.herodotus.oss.dialect.s3.definition.service.BaseS3Service;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.DeleteBucketInventoryConfigurationRequest;
import com.amazonaws.services.s3.model.DeleteBucketInventoryConfigurationResult;
import com.amazonaws.services.s3.model.GetBucketInventoryConfigurationRequest;
import com.amazonaws.services.s3.model.GetBucketInventoryConfigurationResult;
import com.amazonaws.services.s3.model.ListBucketInventoryConfigurationsRequest;
import com.amazonaws.services.s3.model.ListBucketInventoryConfigurationsResult;
import com.amazonaws.services.s3.model.SetBucketInventoryConfigurationRequest;
import com.amazonaws.services.s3.model.SetBucketInventoryConfigurationResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class S3BucketInventoryConfiguration
extends BaseS3Service {
    private static final Logger log = LoggerFactory.getLogger(S3BucketInventoryConfiguration.class);

    public S3BucketInventoryConfiguration(S3ClientObjectPool s3ClientObjectPool) {
        super(s3ClientObjectPool);
    }

    public DeleteBucketInventoryConfigurationResult deleteBucketInventoryConfiguration(DeleteBucketInventoryConfigurationRequest request) {
        String function = "deleteBucketInventoryConfiguration";
        AmazonS3 amazonS3 = (AmazonS3)this.getClient();
        try {
            DeleteBucketInventoryConfigurationResult deleteBucketInventoryConfigurationResult = amazonS3.deleteBucketInventoryConfiguration(request);
            return deleteBucketInventoryConfigurationResult;
        }
        catch (AmazonServiceException e) {
            log.error("[Herodotus] |- Amazon S3 catch AmazonServiceException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        finally {
            this.close(amazonS3);
        }
    }

    public GetBucketInventoryConfigurationResult getBucketInventoryConfiguration(GetBucketInventoryConfigurationRequest request) {
        String function = "getBucketInventoryConfiguration";
        AmazonS3 amazonS3 = (AmazonS3)this.getClient();
        try {
            GetBucketInventoryConfigurationResult getBucketInventoryConfigurationResult = amazonS3.getBucketInventoryConfiguration(request);
            return getBucketInventoryConfigurationResult;
        }
        catch (AmazonServiceException e) {
            log.error("[Herodotus] |- Amazon S3 catch AmazonServiceException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        finally {
            this.close(amazonS3);
        }
    }

    public ListBucketInventoryConfigurationsResult listBucketInventoryConfigurations(ListBucketInventoryConfigurationsRequest request) {
        String function = "listBucketInventoryConfigurations";
        AmazonS3 amazonS3 = (AmazonS3)this.getClient();
        try {
            ListBucketInventoryConfigurationsResult listBucketInventoryConfigurationsResult = amazonS3.listBucketInventoryConfigurations(request);
            return listBucketInventoryConfigurationsResult;
        }
        catch (AmazonServiceException e) {
            log.error("[Herodotus] |- Amazon S3 catch AmazonServiceException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        finally {
            this.close(amazonS3);
        }
    }

    public SetBucketInventoryConfigurationResult setBucketInventoryConfiguration(SetBucketInventoryConfigurationRequest request) {
        String function = "setBucketInventoryConfiguration";
        AmazonS3 amazonS3 = (AmazonS3)this.getClient();
        try {
            SetBucketInventoryConfigurationResult setBucketInventoryConfigurationResult = amazonS3.setBucketInventoryConfiguration(request);
            return setBucketInventoryConfigurationResult;
        }
        catch (AmazonServiceException e) {
            log.error("[Herodotus] |- Amazon S3 catch AmazonServiceException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        finally {
            this.close(amazonS3);
        }
    }
}

