/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.dialect.s3.repository;

import cn.herodotus.oss.dialect.core.client.AbstractOssClientObjectPool;
import cn.herodotus.oss.dialect.core.exception.OssServerException;
import cn.herodotus.oss.dialect.s3.converter.arguments.ArgumentsToDeleteObjectRequestConverter;
import cn.herodotus.oss.dialect.s3.converter.arguments.ArgumentsToDeleteObjectsRequestConverter;
import cn.herodotus.oss.dialect.s3.converter.arguments.ArgumentsToGeneratePreSignedUrlRequestConverter;
import cn.herodotus.oss.dialect.s3.converter.arguments.ArgumentsToGetObjectRequestConverter;
import cn.herodotus.oss.dialect.s3.converter.arguments.ArgumentsToListObjectsRequestConverter;
import cn.herodotus.oss.dialect.s3.converter.arguments.ArgumentsToListObjectsV2RequestConverter;
import cn.herodotus.oss.dialect.s3.converter.arguments.ArgumentsToPutObjectRequestConverter;
import cn.herodotus.oss.dialect.s3.converter.domain.DeleteObjectsResultToDomainConverter;
import cn.herodotus.oss.dialect.s3.converter.domain.ListObjectsV2ResultToDomainConverter;
import cn.herodotus.oss.dialect.s3.converter.domain.ObjectListingToDomainConverter;
import cn.herodotus.oss.dialect.s3.converter.domain.ObjectMetadataToDomainConverter;
import cn.herodotus.oss.dialect.s3.converter.domain.PutObjectResultToDomainConverter;
import cn.herodotus.oss.dialect.s3.converter.domain.S3ObjectToDomainConverter;
import cn.herodotus.oss.dialect.s3.definition.service.BaseS3Service;
import cn.herodotus.oss.specification.arguments.object.DeleteObjectArguments;
import cn.herodotus.oss.specification.arguments.object.DeleteObjectsArguments;
import cn.herodotus.oss.specification.arguments.object.DownloadObjectArguments;
import cn.herodotus.oss.specification.arguments.object.GeneratePresignedUrlArguments;
import cn.herodotus.oss.specification.arguments.object.GetObjectArguments;
import cn.herodotus.oss.specification.arguments.object.GetObjectMetadataArguments;
import cn.herodotus.oss.specification.arguments.object.ListObjectsArguments;
import cn.herodotus.oss.specification.arguments.object.ListObjectsV2Arguments;
import cn.herodotus.oss.specification.arguments.object.PutObjectArguments;
import cn.herodotus.oss.specification.arguments.object.UploadObjectArguments;
import cn.herodotus.oss.specification.core.repository.OssObjectRepository;
import cn.herodotus.oss.specification.domain.base.ObjectWriteDomain;
import cn.herodotus.oss.specification.domain.object.DeleteObjectDomain;
import cn.herodotus.oss.specification.domain.object.GetObjectDomain;
import cn.herodotus.oss.specification.domain.object.ListObjectsDomain;
import cn.herodotus.oss.specification.domain.object.ListObjectsV2Domain;
import cn.herodotus.oss.specification.domain.object.ObjectMetadataDomain;
import cn.herodotus.oss.specification.domain.object.PutObjectDomain;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.DeleteObjectRequest;
import com.amazonaws.services.s3.model.DeleteObjectsRequest;
import com.amazonaws.services.s3.model.DeleteObjectsResult;
import com.amazonaws.services.s3.model.GeneratePresignedUrlRequest;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.ListObjectsRequest;
import com.amazonaws.services.s3.model.ListObjectsV2Request;
import com.amazonaws.services.s3.model.ListObjectsV2Result;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.PutObjectResult;
import com.amazonaws.services.s3.model.S3Object;
import java.io.File;
import java.net.URL;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class S3ObjectRepository
extends BaseS3Service
implements OssObjectRepository {
    private static final Logger log = LoggerFactory.getLogger(S3ObjectRepository.class);

    public S3ObjectRepository(AbstractOssClientObjectPool<AmazonS3> ossClientObjectPool) {
        super(ossClientObjectPool);
    }

    public ListObjectsDomain listObjects(ListObjectsArguments arguments) {
        String function = "listObjects";
        ArgumentsToListObjectsRequestConverter toArgs = new ArgumentsToListObjectsRequestConverter();
        ObjectListingToDomainConverter toDomain = new ObjectListingToDomainConverter();
        AmazonS3 client = (AmazonS3)this.getClient();
        try {
            ObjectListing objectListing = client.listObjects((ListObjectsRequest)toArgs.convert(arguments));
            ListObjectsDomain listObjectsDomain = (ListObjectsDomain)toDomain.convert(objectListing);
            return listObjectsDomain;
        }
        catch (AmazonServiceException e) {
            log.error("[Herodotus] |- Amazon S3 catch AmazonServiceException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        finally {
            this.close(client);
        }
    }

    public ListObjectsV2Domain listObjectsV2(ListObjectsV2Arguments arguments) {
        String function = "listObjectsV2";
        ArgumentsToListObjectsV2RequestConverter toArgs = new ArgumentsToListObjectsV2RequestConverter();
        ListObjectsV2ResultToDomainConverter toDomain = new ListObjectsV2ResultToDomainConverter();
        AmazonS3 client = (AmazonS3)this.getClient();
        try {
            ListObjectsV2Result listObjectsV2Result = client.listObjectsV2((ListObjectsV2Request)toArgs.convert(arguments));
            ListObjectsV2Domain listObjectsV2Domain = (ListObjectsV2Domain)toDomain.convert(listObjectsV2Result);
            return listObjectsV2Domain;
        }
        catch (AmazonServiceException e) {
            log.error("[Herodotus] |- Amazon S3 catch AmazonServiceException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        finally {
            this.close(client);
        }
    }

    public void deleteObject(DeleteObjectArguments arguments) {
        String function = "deleteObject";
        AmazonS3 client = (AmazonS3)this.getClient();
        try {
            ArgumentsToDeleteObjectRequestConverter toArgs = new ArgumentsToDeleteObjectRequestConverter();
            client.deleteObject((DeleteObjectRequest)toArgs.convert(arguments));
        }
        catch (AmazonServiceException e) {
            log.error("[Herodotus] |- Amazon S3 catch AmazonServiceException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        finally {
            this.close(client);
        }
    }

    public List<DeleteObjectDomain> deleteObjects(DeleteObjectsArguments arguments) {
        String function = "deleteObjects";
        AmazonS3 client = (AmazonS3)this.getClient();
        try {
            ArgumentsToDeleteObjectsRequestConverter toArgs = new ArgumentsToDeleteObjectsRequestConverter();
            DeleteObjectsResultToDomainConverter toDomain = new DeleteObjectsResultToDomainConverter();
            DeleteObjectsResult result = client.deleteObjects((DeleteObjectsRequest)toArgs.convert(arguments));
            List list = (List)toDomain.convert(result);
            return list;
        }
        catch (AmazonServiceException e) {
            log.error("[Herodotus] |- Amazon S3 catch AmazonServiceException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        finally {
            this.close(client);
        }
    }

    public ObjectMetadataDomain getObjectMetadata(GetObjectMetadataArguments arguments) {
        return null;
    }

    public GetObjectDomain getObject(GetObjectArguments arguments) {
        String function = "getObject";
        ArgumentsToGetObjectRequestConverter toRequest = new ArgumentsToGetObjectRequestConverter();
        S3ObjectToDomainConverter toDomain = new S3ObjectToDomainConverter();
        AmazonS3 client = (AmazonS3)this.getClient();
        try {
            S3Object object = client.getObject((GetObjectRequest)toRequest.convert(arguments));
            GetObjectDomain getObjectDomain = (GetObjectDomain)toDomain.convert(object);
            return getObjectDomain;
        }
        catch (AmazonServiceException e) {
            log.error("[Herodotus] |- Amazon S3 catch AmazonServiceException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        finally {
            this.close(client);
        }
    }

    public PutObjectDomain putObject(PutObjectArguments arguments) {
        String function = "putObject";
        ArgumentsToPutObjectRequestConverter toRequest = new ArgumentsToPutObjectRequestConverter();
        PutObjectResultToDomainConverter toDomain = new PutObjectResultToDomainConverter();
        AmazonS3 client = (AmazonS3)this.getClient();
        try {
            PutObjectResult result = client.putObject((PutObjectRequest)toRequest.convert(arguments));
            PutObjectDomain putObjectDomain = (PutObjectDomain)toDomain.convert(result);
            return putObjectDomain;
        }
        catch (AmazonServiceException e) {
            log.error("[Herodotus] |- Amazon S3 catch AmazonServiceException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        finally {
            this.close(client);
        }
    }

    public String generatePresignedUrl(GeneratePresignedUrlArguments arguments) {
        String function = "generatePreSignedUrl";
        ArgumentsToGeneratePreSignedUrlRequestConverter toRequest = new ArgumentsToGeneratePreSignedUrlRequestConverter();
        AmazonS3 client = (AmazonS3)this.getClient();
        try {
            URL url = client.generatePresignedUrl((GeneratePresignedUrlRequest)toRequest.convert(arguments));
            String string = url.toString();
            return string;
        }
        catch (AmazonServiceException e) {
            log.error("[Herodotus] |- Amazon S3 catch AmazonServiceException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        finally {
            this.close(client);
        }
    }

    public ObjectMetadataDomain download(DownloadObjectArguments arguments) {
        String function = "download";
        ArgumentsToGetObjectRequestConverter toRequest = new ArgumentsToGetObjectRequestConverter();
        ObjectMetadataToDomainConverter toDomain = new ObjectMetadataToDomainConverter();
        AmazonS3 client = (AmazonS3)this.getClient();
        try {
            ObjectMetadata object = client.getObject((GetObjectRequest)toRequest.convert(arguments), new File(arguments.getFilename()));
            ObjectMetadataDomain objectMetadataDomain = (ObjectMetadataDomain)toDomain.convert(object);
            return objectMetadataDomain;
        }
        catch (AmazonServiceException e) {
            log.error("[Herodotus] |- Amazon S3 catch AmazonServiceException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        finally {
            this.close(client);
        }
    }

    public ObjectWriteDomain upload(UploadObjectArguments arguments) {
        String function = "upload";
        PutObjectResultToDomainConverter toDomain = new PutObjectResultToDomainConverter();
        AmazonS3 client = (AmazonS3)this.getClient();
        try {
            PutObjectResult result = client.putObject(arguments.getBucketName(), arguments.getObjectName(), new File(arguments.getFilename()));
            ObjectWriteDomain objectWriteDomain = (ObjectWriteDomain)toDomain.convert(result);
            return objectWriteDomain;
        }
        catch (AmazonServiceException e) {
            log.error("[Herodotus] |- Amazon S3 catch AmazonServiceException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        finally {
            this.close(client);
        }
    }
}

