/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.dialect.s3.service;

import cn.herodotus.oss.dialect.core.exception.OssServerException;
import cn.herodotus.oss.dialect.s3.definition.pool.S3ClientObjectPool;
import cn.herodotus.oss.dialect.s3.definition.service.BaseS3Service;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.GetObjectRetentionRequest;
import com.amazonaws.services.s3.model.GetObjectRetentionResult;
import com.amazonaws.services.s3.model.SetObjectRetentionRequest;
import com.amazonaws.services.s3.model.SetObjectRetentionResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class S3ObjectRetentionService
extends BaseS3Service {
    private static final Logger log = LoggerFactory.getLogger(S3ObjectRetentionService.class);

    public S3ObjectRetentionService(S3ClientObjectPool s3ClientObjectPool) {
        super(s3ClientObjectPool);
    }

    public GetObjectRetentionResult getObjectRetention(GetObjectRetentionRequest request) {
        String function = "getObjectRetention";
        AmazonS3 amazonS3 = (AmazonS3)this.getClient();
        try {
            GetObjectRetentionResult getObjectRetentionResult = amazonS3.getObjectRetention(request);
            return getObjectRetentionResult;
        }
        catch (AmazonServiceException e) {
            log.error("[Herodotus] |- Amazon S3 catch AmazonServiceException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        finally {
            this.close(amazonS3);
        }
    }

    public SetObjectRetentionResult setObjectRetention(SetObjectRetentionRequest request) {
        String function = "setObjectRetention";
        AmazonS3 amazonS3 = (AmazonS3)this.getClient();
        try {
            SetObjectRetentionResult setObjectRetentionResult = amazonS3.setObjectRetention(request);
            return setObjectRetentionResult;
        }
        catch (AmazonServiceException e) {
            log.error("[Herodotus] |- Amazon S3 catch AmazonServiceException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        finally {
            this.close(amazonS3);
        }
    }
}

