/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.dialect.s3.service;

import cn.herodotus.oss.dialect.core.exception.OssServerException;
import cn.herodotus.oss.dialect.s3.definition.pool.S3ClientObjectPool;
import cn.herodotus.oss.dialect.s3.definition.service.BaseS3Service;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.GetObjectLockConfigurationRequest;
import com.amazonaws.services.s3.model.GetObjectLockConfigurationResult;
import com.amazonaws.services.s3.model.SetObjectLockConfigurationRequest;
import com.amazonaws.services.s3.model.SetObjectLockConfigurationResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class S3ObjectLockConfigurationService
extends BaseS3Service {
    private static final Logger log = LoggerFactory.getLogger(S3ObjectLockConfigurationService.class);

    public S3ObjectLockConfigurationService(S3ClientObjectPool s3ClientObjectPool) {
        super(s3ClientObjectPool);
    }

    public GetObjectLockConfigurationResult getObjectLockConfiguration(GetObjectLockConfigurationRequest request) {
        String function = "getObjectLockConfiguration";
        AmazonS3 amazonS3 = (AmazonS3)this.getClient();
        try {
            GetObjectLockConfigurationResult getObjectLockConfigurationResult = amazonS3.getObjectLockConfiguration(request);
            return getObjectLockConfigurationResult;
        }
        catch (AmazonServiceException e) {
            log.error("[Herodotus] |- Amazon S3 catch AmazonServiceException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        finally {
            this.close(amazonS3);
        }
    }

    public SetObjectLockConfigurationResult setObjectLockConfiguration(SetObjectLockConfigurationRequest request) {
        String function = "setObjectLockConfiguration";
        AmazonS3 amazonS3 = (AmazonS3)this.getClient();
        try {
            SetObjectLockConfigurationResult setObjectLockConfigurationResult = amazonS3.setObjectLockConfiguration(request);
            return setObjectLockConfigurationResult;
        }
        catch (AmazonServiceException e) {
            log.error("[Herodotus] |- Amazon S3 catch AmazonServiceException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        finally {
            this.close(amazonS3);
        }
    }
}

