/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.dialect.s3.converter.arguments;

import cn.herodotus.oss.dialect.s3.definition.arguments.ArgumentsToBucketConverter;
import cn.herodotus.oss.specification.arguments.object.GetObjectArguments;
import com.amazonaws.services.s3.model.GetObjectRequest;
import java.util.Collection;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;

public class ArgumentsToGetObjectRequestConverter
extends ArgumentsToBucketConverter<GetObjectArguments, GetObjectRequest> {
    @Override
    public void prepare(GetObjectArguments arguments, GetObjectRequest request) {
        if (ObjectUtils.isNotEmpty((Object)arguments.getLength()) && ObjectUtils.isNotEmpty((Object)arguments.getOffset())) {
            long start = arguments.getOffset();
            long end = arguments.getOffset() + arguments.getLength() - 1L;
            request.setRange(start, end);
        }
        if (CollectionUtils.isNotEmpty((Collection)arguments.getMatchETag())) {
            request.setMatchingETagConstraints(arguments.getMatchETag());
        }
        if (CollectionUtils.isNotEmpty((Collection)arguments.getNotMatchEtag())) {
            request.setNonmatchingETagConstraints(arguments.getNotMatchEtag());
        }
        if (ObjectUtils.isNotEmpty((Object)arguments.getModifiedSince())) {
            request.setModifiedSinceConstraint(arguments.getModifiedSince());
        }
        if (ObjectUtils.isNotEmpty((Object)arguments.getUnmodifiedSince())) {
            request.setUnmodifiedSinceConstraint(arguments.getUnmodifiedSince());
        }
        super.prepare(arguments, request);
    }

    public GetObjectRequest getInstance(GetObjectArguments source) {
        return new GetObjectRequest(source.getBucketName(), source.getObjectName(), source.getVersionId());
    }
}

