/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.dialect.s3.service;

import cn.herodotus.oss.dialect.core.exception.OssServerException;
import cn.herodotus.oss.dialect.s3.definition.pool.S3ClientObjectPool;
import cn.herodotus.oss.dialect.s3.definition.service.BaseS3Service;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.GetBucketLocationRequest;
import com.amazonaws.services.s3.model.HeadBucketRequest;
import com.amazonaws.services.s3.model.HeadBucketResult;
import com.amazonaws.services.s3.model.ListVersionsRequest;
import com.amazonaws.services.s3.model.VersionListing;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class S3BucketService
extends BaseS3Service {
    private static final Logger log = LoggerFactory.getLogger(S3BucketService.class);

    public S3BucketService(S3ClientObjectPool s3ClientObjectPool) {
        super(s3ClientObjectPool);
    }

    public VersionListing listVersions(ListVersionsRequest request) {
        String function = "listVersions";
        AmazonS3 amazonS3 = (AmazonS3)this.getClient();
        try {
            VersionListing versionListing = amazonS3.listVersions(request);
            return versionListing;
        }
        catch (AmazonServiceException e) {
            log.error("[Herodotus] |- Amazon S3 catch AmazonServiceException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        finally {
            this.close(amazonS3);
        }
    }

    public HeadBucketResult headBucket(HeadBucketRequest request) {
        String function = "headBucket";
        AmazonS3 amazonS3 = (AmazonS3)this.getClient();
        try {
            HeadBucketResult headBucketResult = amazonS3.headBucket(request);
            return headBucketResult;
        }
        catch (AmazonServiceException e) {
            log.error("[Herodotus] |- Amazon S3 catch AmazonServiceException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        finally {
            this.close(amazonS3);
        }
    }

    public String getBucketLocation(GetBucketLocationRequest request) {
        String function = "getBucketLocation";
        AmazonS3 amazonS3 = (AmazonS3)this.getClient();
        try {
            String string = amazonS3.getBucketLocation(request);
            return string;
        }
        catch (AmazonServiceException e) {
            log.error("[Herodotus] |- Amazon S3 catch AmazonServiceException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        finally {
            this.close(amazonS3);
        }
    }
}

