/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.dialect.s3.service;

import cn.herodotus.oss.dialect.core.exception.OssServerException;
import cn.herodotus.oss.dialect.s3.definition.pool.S3ClientObjectPool;
import cn.herodotus.oss.dialect.s3.definition.service.BaseS3Service;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.BucketPolicy;
import com.amazonaws.services.s3.model.DeleteBucketPolicyRequest;
import com.amazonaws.services.s3.model.GetBucketPolicyRequest;
import com.amazonaws.services.s3.model.GetBucketPolicyStatusRequest;
import com.amazonaws.services.s3.model.GetBucketPolicyStatusResult;
import com.amazonaws.services.s3.model.SetBucketPolicyRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class S3BucketPolicyService
extends BaseS3Service {
    private static final Logger log = LoggerFactory.getLogger(S3BucketPolicyService.class);

    public S3BucketPolicyService(S3ClientObjectPool s3ClientObjectPool) {
        super(s3ClientObjectPool);
    }

    public void deleteBucketPolicy(DeleteBucketPolicyRequest request) {
        String function = "deleteBucketPolicy";
        AmazonS3 amazonS3 = (AmazonS3)this.getClient();
        try {
            amazonS3.deleteBucketPolicy(request);
        }
        catch (AmazonServiceException e) {
            log.error("[Herodotus] |- Amazon S3 catch AmazonServiceException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        finally {
            this.close(amazonS3);
        }
    }

    public BucketPolicy getBucketPolicy(GetBucketPolicyRequest request) {
        String function = "getBucketPolicy";
        AmazonS3 amazonS3 = (AmazonS3)this.getClient();
        try {
            BucketPolicy bucketPolicy = amazonS3.getBucketPolicy(request);
            return bucketPolicy;
        }
        catch (AmazonServiceException e) {
            log.error("[Herodotus] |- Amazon S3 catch AmazonServiceException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        finally {
            this.close(amazonS3);
        }
    }

    public GetBucketPolicyStatusResult getBucketPolicyStatus(GetBucketPolicyStatusRequest request) {
        String function = "getBucketPolicyStatus";
        AmazonS3 amazonS3 = (AmazonS3)this.getClient();
        try {
            GetBucketPolicyStatusResult getBucketPolicyStatusResult = amazonS3.getBucketPolicyStatus(request);
            return getBucketPolicyStatusResult;
        }
        catch (AmazonServiceException e) {
            log.error("[Herodotus] |- Amazon S3 catch AmazonServiceException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        finally {
            this.close(amazonS3);
        }
    }

    public void setBucketOwnershipControls(SetBucketPolicyRequest request) {
        String function = "setBucketOwnershipControls";
        AmazonS3 amazonS3 = (AmazonS3)this.getClient();
        try {
            amazonS3.setBucketPolicy(request);
        }
        catch (AmazonServiceException e) {
            log.error("[Herodotus] |- Amazon S3 catch AmazonServiceException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        finally {
            this.close(amazonS3);
        }
    }
}

