/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.dialect.s3.adapter;

import cn.herodotus.oss.definition.adapter.OssBucketAdapter;
import cn.herodotus.oss.definition.arguments.bucket.CreateBucketArguments;
import cn.herodotus.oss.definition.arguments.bucket.DeleteBucketArguments;
import cn.herodotus.oss.definition.domain.bucket.BucketDomain;
import cn.herodotus.oss.dialect.core.client.AbstractOssClientObjectPool;
import cn.herodotus.oss.dialect.core.exception.OssServerException;
import cn.herodotus.oss.dialect.core.utils.ConverterUtils;
import cn.herodotus.oss.dialect.s3.converter.S3ArgumentsToCreateBucketRequestConverter;
import cn.herodotus.oss.dialect.s3.converter.S3ArgumentsToDeleteBucketRequestConverter;
import cn.herodotus.oss.dialect.s3.converter.S3BucketToDomainConverter;
import cn.herodotus.oss.dialect.s3.definition.service.BaseS3Service;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.CreateBucketRequest;
import com.amazonaws.services.s3.model.DeleteBucketRequest;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.convert.converter.Converter;
import org.springframework.stereotype.Service;

@Service
public class S3BucketAdapter
extends BaseS3Service
implements OssBucketAdapter {
    private static final Logger log = LoggerFactory.getLogger(S3BucketAdapter.class);

    public S3BucketAdapter(AbstractOssClientObjectPool<AmazonS3> ossClientObjectPool) {
        super(ossClientObjectPool);
    }

    public boolean doesBucketExist(String bucketName) {
        String function = "doesBucketExistV2";
        AmazonS3 client = (AmazonS3)this.getClient();
        try {
            boolean bl = client.doesBucketExistV2(bucketName);
            return bl;
        }
        catch (AmazonServiceException e) {
            log.error("[Herodotus] |- Amazon S3 catch AmazonServiceException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        finally {
            this.close(client);
        }
    }

    public List<BucketDomain> listBuckets() {
        String function = "listBuckets";
        AmazonS3 client = (AmazonS3)this.getClient();
        try {
            List list = ConverterUtils.toDomains((List)client.listBuckets(), (Converter)new S3BucketToDomainConverter());
            return list;
        }
        catch (AmazonServiceException e) {
            log.error("[Herodotus] |- Amazon S3 catch AmazonServiceException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        finally {
            this.close(client);
        }
    }

    public BucketDomain createBucket(String bucketName) {
        String function = "createBucket";
        AmazonS3 client = (AmazonS3)this.getClient();
        try {
            BucketDomain bucketDomain = (BucketDomain)ConverterUtils.toDomain((Object)client.createBucket(bucketName), (Converter)new S3BucketToDomainConverter());
            return bucketDomain;
        }
        catch (AmazonServiceException e) {
            log.error("[Herodotus] |- Amazon S3 catch AmazonServiceException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        finally {
            this.close(client);
        }
    }

    public BucketDomain createBucket(CreateBucketArguments arguments) {
        String function = "createBucket";
        AmazonS3 client = (AmazonS3)this.getClient();
        try {
            S3ArgumentsToCreateBucketRequestConverter toRequest = new S3ArgumentsToCreateBucketRequestConverter();
            BucketDomain bucketDomain = (BucketDomain)ConverterUtils.toDomain((Object)client.createBucket((CreateBucketRequest)toRequest.convert(arguments)), (Converter)new S3BucketToDomainConverter());
            return bucketDomain;
        }
        catch (AmazonServiceException e) {
            log.error("[Herodotus] |- Amazon S3 catch AmazonServiceException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        finally {
            this.close(client);
        }
    }

    public void deleteBucket(String bucketName) {
        String function = "deleteBucket";
        AmazonS3 client = (AmazonS3)this.getClient();
        try {
            client.deleteBucket(bucketName);
        }
        catch (AmazonServiceException e) {
            log.error("[Herodotus] |- Amazon S3 catch AmazonServiceException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        finally {
            this.close(client);
        }
    }

    public void deleteBucket(DeleteBucketArguments arguments) {
        String function = "deleteBucket";
        AmazonS3 client = (AmazonS3)this.getClient();
        try {
            S3ArgumentsToDeleteBucketRequestConverter toRequest = new S3ArgumentsToDeleteBucketRequestConverter();
            client.deleteBucket((DeleteBucketRequest)toRequest.convert(arguments));
        }
        catch (AmazonServiceException e) {
            log.error("[Herodotus] |- Amazon S3 catch AmazonServiceException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        finally {
            this.close(client);
        }
    }
}

