/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.dialect.minio.service;

import cn.herodotus.oss.dialect.core.exception.OssConnectException;
import cn.herodotus.oss.dialect.core.exception.OssIOException;
import cn.herodotus.oss.dialect.core.exception.OssInvalidKeyException;
import cn.herodotus.oss.dialect.core.exception.OssNoSuchAlgorithmException;
import cn.herodotus.oss.dialect.minio.definition.pool.MinioAdminClientObjectPool;
import cn.herodotus.oss.dialect.minio.definition.service.BaseMinioAdminService;
import io.minio.admin.MinioAdminClient;
import io.minio.admin.QuotaUnit;
import java.io.IOException;
import java.net.ConnectException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class MinioBucketQuotaService
extends BaseMinioAdminService {
    private static final Logger log = LoggerFactory.getLogger(MinioBucketQuotaService.class);

    public MinioBucketQuotaService(MinioAdminClientObjectPool minioAdminClientObjectPool) {
        super(minioAdminClientObjectPool);
    }

    public void setBucketQuota(String bucketName, long size, QuotaUnit unit) {
        String function = "setBucketQuota";
        MinioAdminClient minioAdminClient = (MinioAdminClient)this.getClient();
        try {
            minioAdminClient.setBucketQuota(bucketName, size, unit);
        }
        catch (NoSuchAlgorithmException e) {
            log.error("[Herodotus] |- Minio catch NoSuchAlgorithmException in [{}].", (Object)function, (Object)e);
            throw new OssNoSuchAlgorithmException(e.getMessage());
        }
        catch (InvalidKeyException e) {
            log.error("[Herodotus] |- Minio catch InvalidKeyException in [{}].", (Object)function, (Object)e);
            throw new OssInvalidKeyException(e.getMessage());
        }
        catch (IOException e) {
            log.error("[Herodotus] |- Minio catch IOException in [{}].", (Object)function, (Object)e);
            if (e instanceof ConnectException) {
                throw new OssConnectException(e.getMessage());
            }
            throw new OssIOException(e.getMessage());
        }
        finally {
            this.close(minioAdminClient);
        }
    }

    public void clearBucketQuota(String bucketName) {
        this.setBucketQuota(bucketName, 0L, QuotaUnit.KB);
    }

    public long getBucketQuota(String bucketName) {
        String function = "getBucketQuota";
        MinioAdminClient minioAdminClient = (MinioAdminClient)this.getClient();
        try {
            long l = minioAdminClient.getBucketQuota(bucketName);
            return l;
        }
        catch (NoSuchAlgorithmException e) {
            log.error("[Herodotus] |- Minio catch NoSuchAlgorithmException in [{}].", (Object)function, (Object)e);
            throw new OssNoSuchAlgorithmException(e.getMessage());
        }
        catch (InvalidKeyException e) {
            log.error("[Herodotus] |- Minio catch InvalidKeyException in [{}].", (Object)function, (Object)e);
            throw new OssInvalidKeyException(e.getMessage());
        }
        catch (IOException e) {
            log.error("[Herodotus] |- Minio catch IOException in [{}].", (Object)function, (Object)e);
            if (e instanceof ConnectException) {
                throw new OssConnectException(e.getMessage());
            }
            throw new OssIOException(e.getMessage());
        }
        finally {
            this.close(minioAdminClient);
        }
    }
}

