/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.dialect.minio.service;

import cn.herodotus.oss.dialect.core.exception.OssConnectException;
import cn.herodotus.oss.dialect.core.exception.OssIOException;
import cn.herodotus.oss.dialect.core.exception.OssInvalidKeyException;
import cn.herodotus.oss.dialect.core.exception.OssNoSuchAlgorithmException;
import cn.herodotus.oss.dialect.minio.definition.pool.MinioAdminClientObjectPool;
import cn.herodotus.oss.dialect.minio.definition.service.BaseMinioAdminService;
import io.minio.admin.GroupInfo;
import io.minio.admin.MinioAdminClient;
import io.minio.admin.Status;
import java.io.IOException;
import java.net.ConnectException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class MinioAdminGroupService
extends BaseMinioAdminService {
    private static final Logger log = LoggerFactory.getLogger(MinioAdminGroupService.class);

    public MinioAdminGroupService(MinioAdminClientObjectPool minioAdminClientObjectPool) {
        super(minioAdminClientObjectPool);
    }

    public List<String> listGroups() {
        String function = "listGroups";
        MinioAdminClient minioAdminClient = (MinioAdminClient)this.getClient();
        try {
            List list = minioAdminClient.listGroups();
            return list;
        }
        catch (NoSuchAlgorithmException e) {
            log.error("[Herodotus] |- Minio catch NoSuchAlgorithmException in [{}].", (Object)function, (Object)e);
            throw new OssNoSuchAlgorithmException(e.getMessage());
        }
        catch (InvalidKeyException e) {
            log.error("[Herodotus] |- Minio catch InvalidKeyException in [{}].", (Object)function, (Object)e);
            throw new OssInvalidKeyException(e.getMessage());
        }
        catch (IOException e) {
            log.error("[Herodotus] |- Minio catch IOException in [{}].", (Object)function, (Object)e);
            if (e instanceof ConnectException) {
                throw new OssConnectException(e.getMessage());
            }
            throw new OssIOException(e.getMessage());
        }
        finally {
            this.close(minioAdminClient);
        }
    }

    public GroupInfo getGroupInfo(String group) {
        String function = "getGroupInfo";
        MinioAdminClient minioAdminClient = (MinioAdminClient)this.getClient();
        try {
            GroupInfo groupInfo = minioAdminClient.getGroupInfo(group);
            return groupInfo;
        }
        catch (NoSuchAlgorithmException e) {
            log.error("[Herodotus] |- Minio catch NoSuchAlgorithmException in [{}].", (Object)function, (Object)e);
            throw new OssNoSuchAlgorithmException(e.getMessage());
        }
        catch (InvalidKeyException e) {
            log.error("[Herodotus] |- Minio catch InvalidKeyException in [{}].", (Object)function, (Object)e);
            throw new OssInvalidKeyException(e.getMessage());
        }
        catch (IOException e) {
            log.error("[Herodotus] |- Minio catch IOException in [{}].", (Object)function, (Object)e);
            if (e instanceof ConnectException) {
                throw new OssConnectException(e.getMessage());
            }
            throw new OssIOException(e.getMessage());
        }
        finally {
            this.close(minioAdminClient);
        }
    }

    public void addUpdateGroup(String group, Status groupStatus, List<String> members) {
        String function = "addUpdateGroup";
        MinioAdminClient minioAdminClient = (MinioAdminClient)this.getClient();
        try {
            minioAdminClient.addUpdateGroup(group, groupStatus, members);
        }
        catch (NoSuchAlgorithmException e) {
            log.error("[Herodotus] |- Minio catch NoSuchAlgorithmException in [{}].", (Object)function, (Object)e);
            throw new OssNoSuchAlgorithmException(e.getMessage());
        }
        catch (InvalidKeyException e) {
            log.error("[Herodotus] |- Minio catch InvalidKeyException in [{}].", (Object)function, (Object)e);
            throw new OssInvalidKeyException(e.getMessage());
        }
        catch (IOException e) {
            log.error("[Herodotus] |- Minio catch IOException in [{}].", (Object)function, (Object)e);
            if (e instanceof ConnectException) {
                throw new OssConnectException(e.getMessage());
            }
            throw new OssIOException(e.getMessage());
        }
        finally {
            this.close(minioAdminClient);
        }
    }

    public void removeGroup(String group) {
        String function = "removeGroup";
        MinioAdminClient minioAdminClient = (MinioAdminClient)this.getClient();
        try {
            minioAdminClient.removeGroup(group);
        }
        catch (NoSuchAlgorithmException e) {
            log.error("[Herodotus] |- Minio catch NoSuchAlgorithmException in [{}].", (Object)function, (Object)e);
            throw new OssNoSuchAlgorithmException(e.getMessage());
        }
        catch (InvalidKeyException e) {
            log.error("[Herodotus] |- Minio catch InvalidKeyException in [{}].", (Object)function, (Object)e);
            throw new OssInvalidKeyException(e.getMessage());
        }
        catch (IOException e) {
            log.error("[Herodotus] |- Minio catch IOException in [{}].", (Object)function, (Object)e);
            if (e instanceof ConnectException) {
                throw new OssConnectException(e.getMessage());
            }
            throw new OssIOException(e.getMessage());
        }
        finally {
            this.close(minioAdminClient);
        }
    }
}

