/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.dialect.minio.definition.arguments;

import cn.herodotus.engine.core.definition.utils.DateTimeUtils;
import cn.herodotus.oss.dialect.minio.definition.arguments.ArgumentsToObjectReadConverter;
import cn.herodotus.oss.specification.arguments.base.ObjectConditionalReadArguments;
import io.minio.ObjectConditionalReadArgs;
import java.util.Collection;
import java.util.Date;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class ArgumentsToObjectConditionalReadConverter<S extends ObjectConditionalReadArguments, T extends ObjectConditionalReadArgs, B extends ObjectConditionalReadArgs.Builder<B, T>>
extends ArgumentsToObjectReadConverter<S, T, B> {
    @Override
    public void prepare(S arguments, B builder) {
        if (ObjectUtils.isNotEmpty((Object)arguments.getLength()) && arguments.getLength() >= 0L) {
            builder.length(arguments.getLength());
        }
        if (ObjectUtils.isNotEmpty((Object)arguments.getOffset()) && arguments.getOffset() >= 0L) {
            builder.offset(arguments.getOffset());
        }
        if (CollectionUtils.isNotEmpty((Collection)arguments.getMatchETag())) {
            builder.matchETag(StringUtils.join((Iterable)arguments.getMatchETag(), (String)","));
        }
        if (CollectionUtils.isNotEmpty((Collection)arguments.getNotMatchEtag())) {
            builder.notMatchETag(StringUtils.join((Iterable)arguments.getNotMatchEtag(), (String)","));
        }
        if (ObjectUtils.isNotEmpty((Object)arguments.getModifiedSince())) {
            builder.modifiedSince(DateTimeUtils.dateToZonedDateTime((Date)arguments.getModifiedSince()));
        }
        if (ObjectUtils.isNotEmpty((Object)arguments.getUnmodifiedSince())) {
            builder.unmodifiedSince(DateTimeUtils.dateToZonedDateTime((Date)arguments.getUnmodifiedSince()));
        }
        super.prepare(arguments, builder);
    }
}

