/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.dialect.minio.converter.sse;

import cn.herodotus.oss.dialect.core.exception.OssInvalidKeyException;
import cn.herodotus.oss.dialect.core.exception.OssNoSuchAlgorithmException;
import cn.hutool.v7.crypto.KeyUtil;
import cn.hutool.v7.crypto.symmetric.SymmetricAlgorithm;
import io.minio.ServerSideEncryptionCustomerKey;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.SecretKey;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.convert.converter.Converter;

public class RequestToServerSideEncryptionCustomerKeyConverter
implements Converter<String, ServerSideEncryptionCustomerKey> {
    private static final Logger log = LoggerFactory.getLogger(RequestToServerSideEncryptionCustomerKeyConverter.class);

    public ServerSideEncryptionCustomerKey convert(String customerKey) {
        if (StringUtils.isNotBlank((CharSequence)customerKey)) {
            SecretKey secretKey = KeyUtil.generateKey((String)SymmetricAlgorithm.AES.getValue(), (int)256);
            try {
                return new ServerSideEncryptionCustomerKey(secretKey);
            }
            catch (InvalidKeyException e) {
                log.error("[Herodotus] |- Minio catch InvalidKeyException in ObjectReadRequest prepare.", (Throwable)e);
                throw new OssInvalidKeyException(e.getMessage());
            }
            catch (NoSuchAlgorithmException e) {
                log.error("[Herodotus] |- Minio catch NoSuchAlgorithmException in ObjectReadRequest prepare.", (Throwable)e);
                throw new OssNoSuchAlgorithmException(e.getMessage());
            }
        }
        return null;
    }
}

