/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.dialect.minio.converter.domain;

import cn.herodotus.oss.specification.domain.multipart.PartSummaryDomain;
import io.minio.messages.Part;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.core.convert.converter.Converter;

public class PartToDomainConverter
implements Converter<List<Part>, List<PartSummaryDomain>> {
    public List<PartSummaryDomain> convert(List<Part> source) {
        if (CollectionUtils.isNotEmpty(source)) {
            return source.stream().map(this::convert).toList();
        }
        return new ArrayList<PartSummaryDomain>();
    }

    private PartSummaryDomain convert(Part source) {
        PartSummaryDomain domain = new PartSummaryDomain();
        domain.setPartSize(source.partSize());
        domain.setLastModifiedDate(Date.from(source.lastModified().toInstant()));
        domain.setPartNumber(source.partNumber());
        domain.setEtag(source.etag());
        return domain;
    }
}

