/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.dialect.minio.converter.domain;

import cn.herodotus.oss.dialect.minio.converter.domain.ResultItemToDomainConverter;
import cn.herodotus.oss.dialect.minio.utils.ConverterUtils;
import cn.herodotus.oss.specification.arguments.object.ListObjectsV2Arguments;
import cn.herodotus.oss.specification.domain.object.ListObjectsV2Domain;
import cn.herodotus.oss.specification.domain.object.ObjectDomain;
import io.minio.Result;
import io.minio.messages.Item;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.core.convert.converter.Converter;

public class IterableResultItemV2ToDomainConverter
implements Converter<Iterable<Result<Item>>, ListObjectsV2Domain> {
    private final String bucketName;
    private String prefix;
    private ListObjectsV2Arguments listObjectsV2Arguments;

    public IterableResultItemV2ToDomainConverter(String bucketName) {
        this.bucketName = bucketName;
    }

    public IterableResultItemV2ToDomainConverter(String bucketName, String prefix) {
        this.bucketName = bucketName;
        this.prefix = prefix;
    }

    public IterableResultItemV2ToDomainConverter(ListObjectsV2Arguments listObjectsV2Arguments) {
        this.listObjectsV2Arguments = listObjectsV2Arguments;
        this.bucketName = listObjectsV2Arguments.getBucketName();
        this.prefix = listObjectsV2Arguments.getPrefix();
    }

    public ListObjectsV2Domain convert(Iterable<Result<Item>> source) {
        List<ObjectDomain> objectDomains = ConverterUtils.toDomains(source, new ResultItemToDomainConverter(this.bucketName));
        ListObjectsV2Domain domain = new ListObjectsV2Domain();
        domain.setBucketName(this.bucketName);
        domain.setPrefix(this.prefix);
        if (ObjectUtils.isNotEmpty((Object)this.listObjectsV2Arguments)) {
            domain.setMarker(this.listObjectsV2Arguments.getMarker());
            domain.setDelimiter(this.listObjectsV2Arguments.getDelimiter());
            domain.setMaxKeys(this.listObjectsV2Arguments.getMaxKeys());
            domain.setEncodingType(this.listObjectsV2Arguments.getEncodingType());
            domain.setBucketName(this.listObjectsV2Arguments.getBucketName());
        }
        domain.setSummaries(objectDomains);
        return domain;
    }
}

