/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.dialect.minio.service;

import cn.herodotus.oss.dialect.core.exception.OssConnectException;
import cn.herodotus.oss.dialect.core.exception.OssErrorResponseException;
import cn.herodotus.oss.dialect.core.exception.OssIOException;
import cn.herodotus.oss.dialect.core.exception.OssInsufficientDataException;
import cn.herodotus.oss.dialect.core.exception.OssInternalException;
import cn.herodotus.oss.dialect.core.exception.OssInvalidKeyException;
import cn.herodotus.oss.dialect.core.exception.OssInvalidResponseException;
import cn.herodotus.oss.dialect.core.exception.OssNoSuchAlgorithmException;
import cn.herodotus.oss.dialect.core.exception.OssServerException;
import cn.herodotus.oss.dialect.core.exception.OssXmlParserException;
import cn.herodotus.oss.dialect.minio.definition.pool.MinioClientObjectPool;
import cn.herodotus.oss.dialect.minio.definition.service.BaseMinioService;
import io.minio.DeleteBucketLifecycleArgs;
import io.minio.GetBucketLifecycleArgs;
import io.minio.MinioClient;
import io.minio.SetBucketLifecycleArgs;
import io.minio.errors.ErrorResponseException;
import io.minio.errors.InsufficientDataException;
import io.minio.errors.InternalException;
import io.minio.errors.InvalidResponseException;
import io.minio.errors.ServerException;
import io.minio.errors.XmlParserException;
import io.minio.messages.LifecycleConfiguration;
import io.minio.messages.LifecycleRule;
import java.io.IOException;
import java.net.ConnectException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class MinioBucketLifecycleService
extends BaseMinioService {
    private static final Logger log = LoggerFactory.getLogger(MinioBucketLifecycleService.class);

    public MinioBucketLifecycleService(MinioClientObjectPool minioClientObjectPool) {
        super(minioClientObjectPool);
    }

    public void setBucketLifecycle(String bucketName, List<LifecycleRule> lifecycleRules) {
        this.setBucketLifecycle(bucketName, new LifecycleConfiguration(lifecycleRules));
    }

    public void setBucketLifecycle(String bucketName, String region, List<LifecycleRule> lifecycleRules) {
        this.setBucketLifecycle(bucketName, region, new LifecycleConfiguration(lifecycleRules));
    }

    public void setBucketLifecycle(String bucketName, LifecycleConfiguration lifecycleConfiguration) {
        this.setBucketLifecycle((SetBucketLifecycleArgs)((SetBucketLifecycleArgs.Builder)SetBucketLifecycleArgs.builder().bucket(bucketName)).config(lifecycleConfiguration).build());
    }

    public void setBucketLifecycle(String bucketName, String region, LifecycleConfiguration lifecycleConfiguration) {
        this.setBucketLifecycle((SetBucketLifecycleArgs)((SetBucketLifecycleArgs.Builder)((SetBucketLifecycleArgs.Builder)SetBucketLifecycleArgs.builder().bucket(bucketName)).region(region)).config(lifecycleConfiguration).build());
    }

    public void setBucketLifecycle(SetBucketLifecycleArgs setBucketLifecycleArgs) {
        String function = "setBucketLifecycle";
        MinioClient minioClient = (MinioClient)this.getClient();
        try {
            minioClient.setBucketLifecycle(setBucketLifecycleArgs);
        }
        catch (ErrorResponseException e) {
            log.error("[Herodotus] |- Minio catch ErrorResponseException in [{}].", (Object)function, (Object)e);
            throw new OssErrorResponseException(e.getMessage());
        }
        catch (InsufficientDataException e) {
            log.error("[Herodotus] |- Minio catch InsufficientDataException in [{}].", (Object)function, (Object)e);
            throw new OssInsufficientDataException(e.getMessage());
        }
        catch (InternalException e) {
            log.error("[Herodotus] |- Minio catch InternalException in [{}].", (Object)function, (Object)e);
            throw new OssInternalException(e.getMessage());
        }
        catch (InvalidKeyException e) {
            log.error("[Herodotus] |- Minio catch InvalidKeyException in [{}].", (Object)function, (Object)e);
            throw new OssInvalidKeyException(e.getMessage());
        }
        catch (InvalidResponseException e) {
            log.error("[Herodotus] |- Minio catch InvalidResponseException in [{}].", (Object)function, (Object)e);
            throw new OssInvalidResponseException(e.getMessage());
        }
        catch (IOException e) {
            log.error("[Herodotus] |- Minio catch IOException in [{}].", (Object)function, (Object)e);
            if (e instanceof ConnectException) {
                throw new OssConnectException(e.getMessage());
            }
            throw new OssIOException(e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            log.error("[Herodotus] |- Minio catch NoSuchAlgorithmException in [{}].", (Object)function, (Object)e);
            throw new OssNoSuchAlgorithmException(e.getMessage());
        }
        catch (ServerException e) {
            log.error("[Herodotus] |- Minio catch ServerException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        catch (XmlParserException e) {
            log.error("[Herodotus] |- Minio catch XmlParserException in [{}].", (Object)function, (Object)e);
            throw new OssXmlParserException(e.getMessage());
        }
        finally {
            this.close(minioClient);
        }
    }

    public LifecycleConfiguration getBucketLifecycle(String bucketName) {
        return this.getBucketLifecycle((GetBucketLifecycleArgs)((GetBucketLifecycleArgs.Builder)GetBucketLifecycleArgs.builder().bucket(bucketName)).build());
    }

    public LifecycleConfiguration getBucketLifecycle(String bucketName, String region) {
        return this.getBucketLifecycle((GetBucketLifecycleArgs)((GetBucketLifecycleArgs.Builder)((GetBucketLifecycleArgs.Builder)GetBucketLifecycleArgs.builder().bucket(bucketName)).region(region)).build());
    }

    public LifecycleConfiguration getBucketLifecycle(GetBucketLifecycleArgs getBucketLifecycleArgs) {
        String function = "getBucketLifecycle";
        MinioClient minioClient = (MinioClient)this.getClient();
        try {
            LifecycleConfiguration lifecycleConfiguration = minioClient.getBucketLifecycle(getBucketLifecycleArgs);
            return lifecycleConfiguration;
        }
        catch (ErrorResponseException e) {
            log.error("[Herodotus] |- Minio catch ErrorResponseException in [{}].", (Object)function, (Object)e);
            throw new OssErrorResponseException(e.getMessage());
        }
        catch (InsufficientDataException e) {
            log.error("[Herodotus] |- Minio catch InsufficientDataException in [{}].", (Object)function, (Object)e);
            throw new OssInsufficientDataException(e.getMessage());
        }
        catch (InternalException e) {
            log.error("[Herodotus] |- Minio catch InternalException in [{}].", (Object)function, (Object)e);
            throw new OssInternalException(e.getMessage());
        }
        catch (InvalidKeyException e) {
            log.error("[Herodotus] |- Minio catch InvalidKeyException in [{}].", (Object)function, (Object)e);
            throw new OssInvalidKeyException(e.getMessage());
        }
        catch (InvalidResponseException e) {
            log.error("[Herodotus] |- Minio catch InvalidResponseException in [{}].", (Object)function, (Object)e);
            throw new OssInvalidResponseException(e.getMessage());
        }
        catch (IOException e) {
            log.error("[Herodotus] |- Minio catch IOException in [{}].", (Object)function, (Object)e);
            if (e instanceof ConnectException) {
                throw new OssConnectException(e.getMessage());
            }
            throw new OssIOException(e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            log.error("[Herodotus] |- Minio catch NoSuchAlgorithmException in [{}].", (Object)function, (Object)e);
            throw new OssNoSuchAlgorithmException(e.getMessage());
        }
        catch (ServerException e) {
            log.error("[Herodotus] |- Minio catch ServerException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        catch (XmlParserException e) {
            log.error("[Herodotus] |- Minio catch XmlParserException in [{}].", (Object)function, (Object)e);
            throw new OssXmlParserException(e.getMessage());
        }
        finally {
            this.close(minioClient);
        }
    }

    public void deleteBucketLifecycle(String bucketName) {
        this.deleteBucketLifecycle((DeleteBucketLifecycleArgs)((DeleteBucketLifecycleArgs.Builder)DeleteBucketLifecycleArgs.builder().bucket(bucketName)).build());
    }

    public void deleteBucketLifecycle(String bucketName, String region) {
        this.deleteBucketLifecycle((DeleteBucketLifecycleArgs)((DeleteBucketLifecycleArgs.Builder)((DeleteBucketLifecycleArgs.Builder)DeleteBucketLifecycleArgs.builder().bucket(bucketName)).region(region)).build());
    }

    public void deleteBucketLifecycle(DeleteBucketLifecycleArgs deleteBucketLifecycleArgs) {
        String function = "deleteBucketLifecycle";
        MinioClient minioClient = (MinioClient)this.getClient();
        try {
            minioClient.deleteBucketLifecycle(deleteBucketLifecycleArgs);
        }
        catch (ErrorResponseException e) {
            log.error("[Herodotus] |- Minio catch ErrorResponseException in [{}].", (Object)function, (Object)e);
            throw new OssErrorResponseException(e.getMessage());
        }
        catch (InsufficientDataException e) {
            log.error("[Herodotus] |- Minio catch InsufficientDataException in [{}].", (Object)function, (Object)e);
            throw new OssInsufficientDataException(e.getMessage());
        }
        catch (InternalException e) {
            log.error("[Herodotus] |- Minio catch InternalException in [{}].", (Object)function, (Object)e);
            throw new OssInternalException(e.getMessage());
        }
        catch (InvalidKeyException e) {
            log.error("[Herodotus] |- Minio catch InvalidKeyException in [{}].", (Object)function, (Object)e);
            throw new OssInvalidKeyException(e.getMessage());
        }
        catch (InvalidResponseException e) {
            log.error("[Herodotus] |- Minio catch InvalidResponseException in [{}].", (Object)function, (Object)e);
            throw new OssInvalidResponseException(e.getMessage());
        }
        catch (IOException e) {
            log.error("[Herodotus] |- Minio catch IOException in [{}].", (Object)function, (Object)e);
            if (e instanceof ConnectException) {
                throw new OssConnectException(e.getMessage());
            }
            throw new OssIOException(e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            log.error("[Herodotus] |- Minio catch NoSuchAlgorithmException in [{}].", (Object)function, (Object)e);
            throw new OssNoSuchAlgorithmException(e.getMessage());
        }
        catch (ServerException e) {
            log.error("[Herodotus] |- Minio catch ServerException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        catch (XmlParserException e) {
            log.error("[Herodotus] |- Minio catch XmlParserException in [{}].", (Object)function, (Object)e);
            throw new OssXmlParserException(e.getMessage());
        }
        finally {
            this.close(minioClient);
        }
    }
}

