/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.dialect.minio.repository;

import cn.herodotus.oss.dialect.minio.converter.domain.AbortMultipartUploadResponseToDomainConverter;
import cn.herodotus.oss.dialect.minio.converter.domain.DomainToPartConverter;
import cn.herodotus.oss.dialect.minio.converter.domain.InitiateMultipartUploadResultToDomainConverter;
import cn.herodotus.oss.dialect.minio.converter.domain.ListMultipartUploadsResultToDomainConverter;
import cn.herodotus.oss.dialect.minio.converter.domain.ListPartsResultToDomainConverter;
import cn.herodotus.oss.dialect.minio.converter.domain.ObjectWriteResponseToCompleteMultipartUploadDomainConverter;
import cn.herodotus.oss.dialect.minio.converter.domain.UploadPartCopyResponseToDomainConverter;
import cn.herodotus.oss.dialect.minio.converter.domain.UploadPartResponseToDomainConverter;
import cn.herodotus.oss.dialect.minio.service.MinioMultipartUploadService;
import cn.herodotus.oss.specification.arguments.multipart.AbortMultipartUploadArguments;
import cn.herodotus.oss.specification.arguments.multipart.CompleteMultipartUploadArguments;
import cn.herodotus.oss.specification.arguments.multipart.InitiateMultipartUploadArguments;
import cn.herodotus.oss.specification.arguments.multipart.ListMultipartUploadsArguments;
import cn.herodotus.oss.specification.arguments.multipart.ListPartsArguments;
import cn.herodotus.oss.specification.arguments.multipart.UploadPartArguments;
import cn.herodotus.oss.specification.arguments.multipart.UploadPartCopyArguments;
import cn.herodotus.oss.specification.core.repository.OssMultipartUploadRepository;
import cn.herodotus.oss.specification.domain.multipart.AbortMultipartUploadDomain;
import cn.herodotus.oss.specification.domain.multipart.CompleteMultipartUploadDomain;
import cn.herodotus.oss.specification.domain.multipart.InitiateMultipartUploadDomain;
import cn.herodotus.oss.specification.domain.multipart.ListMultipartUploadsDomain;
import cn.herodotus.oss.specification.domain.multipart.ListPartsDomain;
import cn.herodotus.oss.specification.domain.multipart.UploadPartCopyDomain;
import cn.herodotus.oss.specification.domain.multipart.UploadPartDomain;
import io.minio.AbortMultipartUploadResponse;
import io.minio.CreateMultipartUploadResponse;
import io.minio.ListMultipartUploadsResponse;
import io.minio.ListPartsResponse;
import io.minio.ObjectWriteResponse;
import io.minio.UploadPartCopyResponse;
import io.minio.UploadPartResponse;
import io.minio.messages.Part;
import org.springframework.stereotype.Service;

@Service
public class MinioMultipartUploadRepository
implements OssMultipartUploadRepository {
    private final MinioMultipartUploadService minioMultipartUploadService;

    public MinioMultipartUploadRepository(MinioMultipartUploadService minioMultipartUploadService) {
        this.minioMultipartUploadService = minioMultipartUploadService;
    }

    public InitiateMultipartUploadDomain initiateMultipartUpload(InitiateMultipartUploadArguments arguments) {
        InitiateMultipartUploadResultToDomainConverter toDomain = new InitiateMultipartUploadResultToDomainConverter();
        CreateMultipartUploadResponse response = this.minioMultipartUploadService.createMultipartUpload(arguments.getBucketName(), arguments.getRegion(), arguments.getObjectName(), arguments.getExtraHeaders(), arguments.getExtraQueryParams());
        return (InitiateMultipartUploadDomain)toDomain.convert(response.result());
    }

    public UploadPartDomain uploadPart(UploadPartArguments arguments) {
        UploadPartResponseToDomainConverter toDomain = new UploadPartResponseToDomainConverter();
        UploadPartResponse response = this.minioMultipartUploadService.uploadPart(arguments.getBucketName(), arguments.getRegion(), arguments.getObjectName(), arguments.getInputStream(), arguments.getPartSize(), arguments.getUploadId(), arguments.getPartNumber(), arguments.getExtraHeaders(), arguments.getExtraQueryParams());
        return (UploadPartDomain)toDomain.convert(response);
    }

    public UploadPartCopyDomain uploadPartCopy(UploadPartCopyArguments arguments) {
        UploadPartCopyResponseToDomainConverter toDomain = new UploadPartCopyResponseToDomainConverter();
        UploadPartCopyResponse response = this.minioMultipartUploadService.uploadPartCopy(arguments.getBucketName(), arguments.getRegion(), arguments.getObjectName(), arguments.getUploadId(), arguments.getPartNumber(), arguments.getExtraHeaders(), arguments.getExtraQueryParams());
        return (UploadPartCopyDomain)toDomain.convert(response);
    }

    public CompleteMultipartUploadDomain completeMultipartUpload(CompleteMultipartUploadArguments arguments) {
        DomainToPartConverter toPart = new DomainToPartConverter();
        ObjectWriteResponseToCompleteMultipartUploadDomainConverter toDomain = new ObjectWriteResponseToCompleteMultipartUploadDomainConverter();
        ObjectWriteResponse response = this.minioMultipartUploadService.completeMultipartUpload(arguments.getBucketName(), arguments.getRegion(), arguments.getObjectName(), arguments.getUploadId(), (Part[])toPart.convert(arguments.getParts()), arguments.getExtraHeaders(), arguments.getExtraQueryParams());
        return (CompleteMultipartUploadDomain)toDomain.convert(response);
    }

    public AbortMultipartUploadDomain abortMultipartUpload(AbortMultipartUploadArguments arguments) {
        AbortMultipartUploadResponseToDomainConverter toDomain = new AbortMultipartUploadResponseToDomainConverter();
        AbortMultipartUploadResponse response = this.minioMultipartUploadService.abortMultipartUpload(arguments.getBucketName(), arguments.getRegion(), arguments.getObjectName(), arguments.getUploadId(), arguments.getExtraHeaders(), arguments.getExtraQueryParams());
        return (AbortMultipartUploadDomain)toDomain.convert(response);
    }

    public ListPartsDomain listParts(ListPartsArguments arguments) {
        ListPartsResultToDomainConverter toDomain = new ListPartsResultToDomainConverter(arguments);
        ListPartsResponse response = this.minioMultipartUploadService.listParts(arguments.getBucketName(), arguments.getRegion(), arguments.getObjectName(), arguments.getMaxParts(), arguments.getPartNumberMarker(), arguments.getUploadId(), arguments.getExtraHeaders(), arguments.getExtraQueryParams());
        return (ListPartsDomain)toDomain.convert(response.result());
    }

    public ListMultipartUploadsDomain listMultipartUploads(ListMultipartUploadsArguments arguments) {
        ListMultipartUploadsResultToDomainConverter toDomain = new ListMultipartUploadsResultToDomainConverter(arguments);
        ListMultipartUploadsResponse response = this.minioMultipartUploadService.listMultipartUploads(arguments.getBucketName(), arguments.getRegion(), arguments.getDelimiter(), arguments.getEncodingType(), arguments.getKeyMarker(), arguments.getMaxUploads(), arguments.getPrefix(), arguments.getUploadIdMarker(), arguments.getExtraHeaders(), arguments.getExtraQueryParams());
        return (ListMultipartUploadsDomain)toDomain.convert(response.result());
    }
}

