/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.dialect.minio.converter.retention;

import cn.herodotus.oss.dialect.minio.converter.retention.EnumToRetentionModeConverter;
import cn.herodotus.oss.dialect.minio.domain.ObjectLockConfigurationDomain;
import cn.herodotus.oss.dialect.minio.enums.RetentionModeEnums;
import cn.herodotus.oss.dialect.minio.enums.RetentionUnitEnums;
import io.minio.messages.ObjectLockConfiguration;
import io.minio.messages.RetentionDuration;
import io.minio.messages.RetentionDurationDays;
import io.minio.messages.RetentionDurationYears;
import io.minio.messages.RetentionMode;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.core.convert.converter.Converter;

public class DomainToObjectLockConfigurationConverter
implements Converter<ObjectLockConfigurationDomain, ObjectLockConfiguration> {
    private final Converter<RetentionModeEnums, RetentionMode> toRetentionMode = new EnumToRetentionModeConverter();

    public ObjectLockConfiguration convert(ObjectLockConfigurationDomain source) {
        if (this.isRetentionModeValid(source) && this.isRetentionDurationModeValid(source)) {
            RetentionMode mode = (RetentionMode)this.toRetentionMode.convert((Object)source.getMode());
            RetentionDuration duration = this.getRetentionDuration(source.getUnit(), source.getValidity());
            return new ObjectLockConfiguration(mode, duration);
        }
        return null;
    }

    private boolean isRetentionModeValid(ObjectLockConfigurationDomain source) {
        RetentionModeEnums enums = source.getMode();
        return ObjectUtils.isNotEmpty((Object)((Object)enums));
    }

    private boolean isRetentionDurationModeValid(ObjectLockConfigurationDomain source) {
        RetentionUnitEnums enums = source.getUnit();
        Integer duration = source.getValidity();
        return ObjectUtils.isNotEmpty((Object)((Object)enums)) && ObjectUtils.isNotEmpty((Object)duration) && duration != 0;
    }

    private RetentionDuration getRetentionDuration(RetentionUnitEnums enums, Integer duration) {
        if (enums == RetentionUnitEnums.DAYS) {
            return new RetentionDurationDays(duration.intValue());
        }
        return new RetentionDurationYears(duration.intValue());
    }
}

