/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.dialect.minio.converter.domain;

import cn.herodotus.oss.dialect.minio.converter.domain.ResultItemToDomainConverter;
import cn.herodotus.oss.dialect.minio.utils.ConverterUtils;
import cn.herodotus.oss.specification.arguments.object.ListObjectsArguments;
import cn.herodotus.oss.specification.domain.object.ListObjectsDomain;
import cn.herodotus.oss.specification.domain.object.ObjectDomain;
import io.minio.Result;
import io.minio.messages.Item;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.core.convert.converter.Converter;

public class IterableResultItemToDomainConverter
implements Converter<Iterable<Result<Item>>, ListObjectsDomain> {
    private final String bucketName;
    private String prefix;
    private ListObjectsArguments listObjectsArguments;

    public IterableResultItemToDomainConverter(String bucketName) {
        this.bucketName = bucketName;
    }

    public IterableResultItemToDomainConverter(String bucketName, String prefix) {
        this.bucketName = bucketName;
        this.prefix = prefix;
    }

    public IterableResultItemToDomainConverter(ListObjectsArguments listObjectsArguments) {
        this.listObjectsArguments = listObjectsArguments;
        this.bucketName = listObjectsArguments.getBucketName();
        this.prefix = listObjectsArguments.getPrefix();
    }

    public ListObjectsDomain convert(Iterable<Result<Item>> source) {
        List<ObjectDomain> objectDomains = ConverterUtils.toDomains(source, new ResultItemToDomainConverter(this.bucketName));
        ListObjectsDomain domain = new ListObjectsDomain();
        domain.setBucketName(this.bucketName);
        domain.setPrefix(this.prefix);
        if (ObjectUtils.isNotEmpty((Object)this.listObjectsArguments)) {
            domain.setMarker(this.listObjectsArguments.getMarker());
            domain.setDelimiter(this.listObjectsArguments.getDelimiter());
            domain.setMaxKeys(this.listObjectsArguments.getMaxKeys());
            domain.setEncodingType(this.listObjectsArguments.getEncodingType());
            domain.setBucketName(this.listObjectsArguments.getBucketName());
        }
        domain.setSummaries(objectDomains);
        return domain;
    }
}

