/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.dialect.minio.converter;

import cn.herodotus.engine.assistant.core.utils.type.DateTimeUtils;
import cn.herodotus.oss.dialect.minio.converter.retention.RetentionModeToEnumConverter;
import cn.herodotus.oss.dialect.minio.domain.StatObjectDomain;
import cn.herodotus.oss.dialect.minio.enums.RetentionModeEnums;
import io.minio.StatObjectResponse;
import io.minio.messages.RetentionMode;
import java.time.ZonedDateTime;
import org.springframework.core.convert.converter.Converter;

public class ResponseToStatObjectDomainConverter
implements Converter<StatObjectResponse, StatObjectDomain> {
    private final Converter<RetentionMode, RetentionModeEnums> toRetentionModeEnums = new RetentionModeToEnumConverter();

    public StatObjectDomain convert(StatObjectResponse response) {
        StatObjectDomain domain = new StatObjectDomain();
        domain.setEtag(response.etag());
        domain.setSize(response.size());
        domain.setLastModified(DateTimeUtils.zonedDateTimeToString((ZonedDateTime)response.lastModified()));
        domain.setRetentionMode((RetentionModeEnums)((Object)this.toRetentionModeEnums.convert((Object)response.retentionMode())));
        domain.setRetentionRetainUntilDate(DateTimeUtils.zonedDateTimeToString((ZonedDateTime)response.retentionRetainUntilDate()));
        domain.setLegalHold(response.legalHold().status());
        domain.setDeleteMarker(response.deleteMarker());
        domain.setUserMetadata(response.userMetadata());
        domain.setBucketName(response.bucket());
        domain.setRegion(response.region());
        domain.setObjectName(response.object());
        return domain;
    }
}

