/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.dialect.minio.utils;

import io.minio.Result;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.collections4.MapUtils;
import org.springframework.core.convert.converter.Converter;
import org.springframework.util.StringUtils;

public class ConverterUtils {
    public static <T, R> List<R> toDomains(List<T> items, Converter<T, R> toDomain) {
        if (CollectionUtils.isNotEmpty(items)) {
            return items.stream().map(arg_0 -> toDomain.convert(arg_0)).toList();
        }
        return new ArrayList();
    }

    public static <T, R> List<R> toDomains(Iterable<Result<T>> iterable, Converter<Result<T>, R> toDomain) {
        ArrayList<Object> domains = new ArrayList<Object>();
        if (!IterableUtils.isEmpty(iterable)) {
            for (Result<T> result : iterable) {
                Object response = toDomain.convert(result);
                domains.add(response);
            }
        }
        return domains;
    }

    public static Map<String, String> toMap(Map<String, List<String>> multimap) {
        if (MapUtils.isNotEmpty(multimap)) {
            return multimap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> StringUtils.collectionToCommaDelimitedString((Collection)((Collection)entry.getValue()))));
        }
        return new HashMap<String, String>();
    }
}

