/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.dialect.minio.service;

import cn.herodotus.oss.dialect.core.exception.OssConnectException;
import cn.herodotus.oss.dialect.core.exception.OssErrorResponseException;
import cn.herodotus.oss.dialect.core.exception.OssIOException;
import cn.herodotus.oss.dialect.core.exception.OssInsufficientDataException;
import cn.herodotus.oss.dialect.core.exception.OssInternalException;
import cn.herodotus.oss.dialect.core.exception.OssInvalidKeyException;
import cn.herodotus.oss.dialect.core.exception.OssInvalidResponseException;
import cn.herodotus.oss.dialect.core.exception.OssNoSuchAlgorithmException;
import cn.herodotus.oss.dialect.core.exception.OssServerException;
import cn.herodotus.oss.dialect.core.exception.OssXmlParserException;
import cn.herodotus.oss.dialect.minio.definition.pool.MinioClientObjectPool;
import cn.herodotus.oss.dialect.minio.definition.service.BaseMinioService;
import cn.herodotus.oss.dialect.minio.service.MinioBucketPolicyService;
import io.minio.DeleteBucketTagsArgs;
import io.minio.GetBucketTagsArgs;
import io.minio.MinioClient;
import io.minio.SetBucketTagsArgs;
import io.minio.errors.ErrorResponseException;
import io.minio.errors.InsufficientDataException;
import io.minio.errors.InternalException;
import io.minio.errors.InvalidResponseException;
import io.minio.errors.ServerException;
import io.minio.errors.XmlParserException;
import io.minio.messages.Tags;
import java.io.IOException;
import java.net.ConnectException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class MinioBucketTagsService
extends BaseMinioService {
    private static final Logger log = LoggerFactory.getLogger(MinioBucketPolicyService.class);

    public MinioBucketTagsService(MinioClientObjectPool minioClientObjectPool) {
        super(minioClientObjectPool);
    }

    public Tags getBucketTags(String bucketName) {
        return this.getBucketTags(bucketName, null);
    }

    public Tags getBucketTags(String bucketName, String region) {
        return this.getBucketTags((GetBucketTagsArgs)((GetBucketTagsArgs.Builder)((GetBucketTagsArgs.Builder)GetBucketTagsArgs.builder().bucket(bucketName)).region(region)).build());
    }

    public Tags getBucketTags(GetBucketTagsArgs getBucketTagsArgs) {
        String function = "getBucketTags";
        MinioClient minioClient = (MinioClient)this.getClient();
        try {
            Tags tags = minioClient.getBucketTags(getBucketTagsArgs);
            return tags;
        }
        catch (ErrorResponseException e) {
            log.error("[Herodotus] |- Minio catch ErrorResponseException in [{}].", (Object)function, (Object)e);
            throw new OssErrorResponseException(e.getMessage());
        }
        catch (InsufficientDataException e) {
            log.error("[Herodotus] |- Minio catch InsufficientDataException in [{}].", (Object)function, (Object)e);
            throw new OssInsufficientDataException(e.getMessage());
        }
        catch (InternalException e) {
            log.error("[Herodotus] |- Minio catch InternalException in [{}].", (Object)function, (Object)e);
            throw new OssInternalException(e.getMessage());
        }
        catch (InvalidKeyException e) {
            log.error("[Herodotus] |- Minio catch InvalidKeyException in [{}].", (Object)function, (Object)e);
            throw new OssInvalidKeyException(e.getMessage());
        }
        catch (InvalidResponseException e) {
            log.error("[Herodotus] |- Minio catch InvalidResponseException in [{}].", (Object)function, (Object)e);
            throw new OssInvalidResponseException(e.getMessage());
        }
        catch (IOException e) {
            log.error("[Herodotus] |- Minio catch IOException in [{}].", (Object)function, (Object)e);
            if (e instanceof ConnectException) {
                throw new OssConnectException(e.getMessage());
            }
            throw new OssIOException(e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            log.error("[Herodotus] |- Minio catch NoSuchAlgorithmException in [{}].", (Object)function, (Object)e);
            throw new OssNoSuchAlgorithmException(e.getMessage());
        }
        catch (ServerException e) {
            log.error("[Herodotus] |- Minio catch ServerException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        catch (XmlParserException e) {
            log.error("[Herodotus] |- Minio catch XmlParserException in createBucket.", (Throwable)e);
            throw new OssXmlParserException(e.getMessage());
        }
        finally {
            this.close(minioClient);
        }
    }

    public void setBucketTags(String bucketName, Tags tags) {
        this.setBucketTags(bucketName, null, tags);
    }

    public void setBucketTags(String bucketName, String region, Tags tags) {
        this.setBucketTags((SetBucketTagsArgs)((SetBucketTagsArgs.Builder)((SetBucketTagsArgs.Builder)SetBucketTagsArgs.builder().bucket(bucketName)).region(region)).tags(tags).build());
    }

    public void setBucketTags(SetBucketTagsArgs setBucketTagsArgs) {
        String function = "setBucketTags";
        MinioClient minioClient = (MinioClient)this.getClient();
        try {
            minioClient.setBucketTags(setBucketTagsArgs);
        }
        catch (ErrorResponseException e) {
            log.error("[Herodotus] |- Minio catch ErrorResponseException in [{}].", (Object)function, (Object)e);
            throw new OssErrorResponseException(e.getMessage());
        }
        catch (InsufficientDataException e) {
            log.error("[Herodotus] |- Minio catch InsufficientDataException in [{}].", (Object)function, (Object)e);
            throw new OssInsufficientDataException(e.getMessage());
        }
        catch (InternalException e) {
            log.error("[Herodotus] |- Minio catch InternalException in [{}].", (Object)function, (Object)e);
            throw new OssInternalException(e.getMessage());
        }
        catch (InvalidKeyException e) {
            log.error("[Herodotus] |- Minio catch InvalidKeyException in [{}].", (Object)function, (Object)e);
            throw new OssInvalidKeyException(e.getMessage());
        }
        catch (InvalidResponseException e) {
            log.error("[Herodotus] |- Minio catch InvalidResponseException in [{}].", (Object)function, (Object)e);
            throw new OssInvalidResponseException(e.getMessage());
        }
        catch (IOException e) {
            log.error("[Herodotus] |- Minio catch IOException in [{}].", (Object)function, (Object)e);
            if (e instanceof ConnectException) {
                throw new OssConnectException(e.getMessage());
            }
            throw new OssIOException(e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            log.error("[Herodotus] |- Minio catch NoSuchAlgorithmException in [{}].", (Object)function, (Object)e);
            throw new OssNoSuchAlgorithmException(e.getMessage());
        }
        catch (ServerException e) {
            log.error("[Herodotus] |- Minio catch ServerException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        catch (XmlParserException e) {
            log.error("[Herodotus] |- Minio catch XmlParserException in [{}].", (Object)function, (Object)e);
            throw new OssXmlParserException(e.getMessage());
        }
        finally {
            this.close(minioClient);
        }
    }

    public void deleteBucketTags(String bucketName) {
        this.deleteBucketTags(bucketName, null);
    }

    public void deleteBucketTags(String bucketName, String region) {
        this.deleteBucketTags((DeleteBucketTagsArgs)((DeleteBucketTagsArgs.Builder)((DeleteBucketTagsArgs.Builder)DeleteBucketTagsArgs.builder().bucket(bucketName)).region(region)).build());
    }

    public void deleteBucketTags(DeleteBucketTagsArgs deleteBucketTagsArgs) {
        String function = "deleteBucketTags";
        MinioClient minioClient = (MinioClient)this.getClient();
        try {
            minioClient.deleteBucketTags(deleteBucketTagsArgs);
        }
        catch (ErrorResponseException e) {
            log.error("[Herodotus] |- Minio catch ErrorResponseException in [{}].", (Object)function, (Object)e);
            throw new OssErrorResponseException(e.getMessage());
        }
        catch (InsufficientDataException e) {
            log.error("[Herodotus] |- Minio catch InsufficientDataException in [{}].", (Object)function, (Object)e);
            throw new OssInsufficientDataException(e.getMessage());
        }
        catch (InternalException e) {
            log.error("[Herodotus] |- Minio catch InternalException in [{}].", (Object)function, (Object)e);
            throw new OssInternalException(e.getMessage());
        }
        catch (InvalidKeyException e) {
            log.error("[Herodotus] |- Minio catch InvalidKeyException in [{}].", (Object)function, (Object)e);
            throw new OssInvalidKeyException(e.getMessage());
        }
        catch (InvalidResponseException e) {
            log.error("[Herodotus] |- Minio catch InvalidResponseException in [{}].", (Object)function, (Object)e);
            throw new OssInvalidResponseException(e.getMessage());
        }
        catch (IOException e) {
            log.error("[Herodotus] |- Minio catch IOException in [{}].", (Object)function, (Object)e);
            if (e instanceof ConnectException) {
                throw new OssConnectException(e.getMessage());
            }
            throw new OssIOException(e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            log.error("[Herodotus] |- Minio catch NoSuchAlgorithmException in [{}].", (Object)function, (Object)e);
            throw new OssNoSuchAlgorithmException(e.getMessage());
        }
        catch (ServerException e) {
            log.error("[Herodotus] |- Minio catch ServerException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        catch (XmlParserException e) {
            log.error("[Herodotus] |- Minio catch XmlParserException in [{}].", (Object)function, (Object)e);
            throw new OssXmlParserException(e.getMessage());
        }
        finally {
            this.close(minioClient);
        }
    }
}

