/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.dialect.minio.converter.sse;

import cn.herodotus.oss.dialect.minio.converter.sse.RequestToServerSideEncryptionCustomerKeyConverter;
import cn.herodotus.oss.dialect.minio.domain.ServerSideEncryptionDomain;
import cn.herodotus.oss.dialect.minio.enums.ServerSideEncryptionEnums;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.minio.ServerSideEncryption;
import io.minio.ServerSideEncryptionCustomerKey;
import io.minio.ServerSideEncryptionKms;
import io.minio.ServerSideEncryptionS3;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.convert.converter.Converter;

public class RequestToServerSideEncryptionConverter
implements Converter<ServerSideEncryptionDomain, ServerSideEncryption> {
    private static final Logger log = LoggerFactory.getLogger(RequestToServerSideEncryptionConverter.class);
    private final Converter<String, ServerSideEncryptionCustomerKey> toCustomerKey = new RequestToServerSideEncryptionCustomerKeyConverter();

    public ServerSideEncryption convert(ServerSideEncryptionDomain source) {
        if (ObjectUtils.isNotEmpty((Object)((Object)source.getType()))) {
            ServerSideEncryptionEnums type = source.getType();
            switch (type) {
                case CUSTOM: {
                    if (StringUtils.isNotBlank((CharSequence)source.getCustomerKey())) {
                        return (ServerSideEncryption)this.toCustomerKey.convert((Object)source.getCustomerKey());
                    }
                    return null;
                }
                case AWS_KMS: {
                    if (!StringUtils.isNotBlank((CharSequence)source.getKeyId())) break;
                    try {
                        return new ServerSideEncryptionKms(source.getKeyId(), source.getContext());
                    }
                    catch (JsonProcessingException e) {
                        log.error("[Herodotus] |- Minio catch JsonProcessingException in RequestToServerSideEncryptionConverter.", (Throwable)e);
                        return null;
                    }
                }
                default: {
                    return new ServerSideEncryptionS3();
                }
            }
        }
        return null;
    }
}

