/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.dialect.minio.converter.domain;

import cn.herodotus.oss.dialect.minio.converter.domain.InitiatorToDomainConverter;
import cn.herodotus.oss.dialect.minio.converter.domain.OwnerToDomainConverter;
import cn.herodotus.oss.specification.domain.base.OwnerDomain;
import cn.herodotus.oss.specification.domain.multipart.UploadDomain;
import io.minio.messages.Initiator;
import io.minio.messages.Owner;
import io.minio.messages.Upload;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.core.convert.converter.Converter;

public class UploadToDomainConverter
implements Converter<List<Upload>, List<UploadDomain>> {
    private final Converter<Owner, OwnerDomain> owner = new OwnerToDomainConverter();
    private final Converter<Initiator, OwnerDomain> initiator = new InitiatorToDomainConverter();

    public List<UploadDomain> convert(List<Upload> source) {
        if (CollectionUtils.isNotEmpty(source)) {
            return source.stream().map(this::convert).toList();
        }
        return new ArrayList<UploadDomain>();
    }

    private UploadDomain convert(Upload source) {
        UploadDomain domain = new UploadDomain();
        domain.setKey(source.objectName());
        domain.setUploadId(source.uploadId());
        domain.setOwner((OwnerDomain)this.owner.convert((Object)source.owner()));
        domain.setInitiator((OwnerDomain)this.initiator.convert((Object)source.initiator()));
        domain.setStorageClass(source.storageClass());
        domain.setInitiated(Date.from(source.initiated().toInstant()));
        return domain;
    }
}

