/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.dialect.minio.converter.domain;

import cn.herodotus.engine.assistant.core.utils.type.DateTimeUtils;
import cn.herodotus.oss.specification.domain.object.ObjectMetadataDomain;
import io.minio.StatObjectResponse;
import java.time.ZonedDateTime;
import org.springframework.core.convert.converter.Converter;

public class StatObjectResponseToDomainConverter
implements Converter<StatObjectResponse, ObjectMetadataDomain> {
    public ObjectMetadataDomain convert(StatObjectResponse source) {
        ObjectMetadataDomain domain = new ObjectMetadataDomain();
        domain.setUserMetadata(source.userMetadata());
        domain.setContentLength(source.size());
        domain.setContentType(source.contentType());
        domain.setLastModified(DateTimeUtils.zonedDateTimeToDate((ZonedDateTime)source.lastModified()));
        domain.setEtag(source.etag());
        domain.setVersionId(source.versionId());
        domain.setBucketName(source.bucket());
        domain.setRegion(source.region());
        domain.setObjectName(source.object());
        return domain;
    }
}

