/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.dialect.minio.service;

import cn.herodotus.oss.dialect.core.exception.OssConnectException;
import cn.herodotus.oss.dialect.core.exception.OssIOException;
import cn.herodotus.oss.dialect.core.exception.OssInvalidCipherTextException;
import cn.herodotus.oss.dialect.core.exception.OssInvalidKeyException;
import cn.herodotus.oss.dialect.core.exception.OssNoSuchAlgorithmException;
import cn.herodotus.oss.dialect.minio.definition.pool.MinioAdminClientObjectPool;
import cn.herodotus.oss.dialect.minio.definition.service.BaseMinioAdminService;
import io.minio.admin.MinioAdminClient;
import io.minio.admin.UserInfo;
import java.io.IOException;
import java.net.ConnectException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class MinioAdminUserService
extends BaseMinioAdminService {
    private static final Logger log = LoggerFactory.getLogger(MinioAdminUserService.class);

    public MinioAdminUserService(MinioAdminClientObjectPool minioAdminClientObjectPool) {
        super(minioAdminClientObjectPool);
    }

    public Map<String, UserInfo> listUsers() {
        String function = "listUsers";
        MinioAdminClient minioAdminClient = (MinioAdminClient)this.getClient();
        try {
            Map map = minioAdminClient.listUsers();
            return map;
        }
        catch (NoSuchAlgorithmException e) {
            log.error("[Herodotus] |- Minio catch NoSuchAlgorithmException in [{}].", (Object)function, (Object)e);
            throw new OssNoSuchAlgorithmException(e.getMessage());
        }
        catch (InvalidKeyException e) {
            log.error("[Herodotus] |- Minio catch InvalidKeyException in [{}].", (Object)function, (Object)e);
            throw new OssInvalidKeyException(e.getMessage());
        }
        catch (IOException e) {
            log.error("[Herodotus] |- Minio catch IOException in [{}].", (Object)function, (Object)e);
            if (e instanceof ConnectException) {
                throw new OssConnectException(e.getMessage());
            }
            throw new OssIOException(e.getMessage());
        }
        catch (InvalidCipherTextException e) {
            log.error("[Herodotus] |- Minio catch InvalidCipherTextException in [{}].", (Object)function, (Object)e);
            throw new OssInvalidCipherTextException(e.getMessage());
        }
        finally {
            this.close(minioAdminClient);
        }
    }

    public UserInfo getUserInfo(String accessKey) {
        String function = "getUserInfo";
        MinioAdminClient minioAdminClient = (MinioAdminClient)this.getClient();
        try {
            UserInfo userInfo = minioAdminClient.getUserInfo(accessKey);
            return userInfo;
        }
        catch (NoSuchAlgorithmException e) {
            log.error("[Herodotus] |- Minio catch NoSuchAlgorithmException in [{}].", (Object)function, (Object)e);
            throw new OssNoSuchAlgorithmException(e.getMessage());
        }
        catch (InvalidKeyException e) {
            log.error("[Herodotus] |- Minio catch InvalidKeyException in [{}].", (Object)function, (Object)e);
            throw new OssInvalidKeyException(e.getMessage());
        }
        catch (IOException e) {
            log.error("[Herodotus] |- Minio catch IOException in [{}].", (Object)function, (Object)e);
            if (e instanceof ConnectException) {
                throw new OssConnectException(e.getMessage());
            }
            throw new OssIOException(e.getMessage());
        }
        finally {
            this.close(minioAdminClient);
        }
    }

    public void addUser(@Nonnull String accessKey, @Nonnull UserInfo.Status status, @Nullable String secretKey, @Nullable String policyName, @Nullable List<String> memberOf) {
        String function = "addUser";
        MinioAdminClient minioAdminClient = (MinioAdminClient)this.getClient();
        try {
            minioAdminClient.addUser(accessKey, status, secretKey, policyName, memberOf);
        }
        catch (NoSuchAlgorithmException e) {
            log.error("[Herodotus] |- Minio catch NoSuchAlgorithmException in [{}].", (Object)function, (Object)e);
            throw new OssNoSuchAlgorithmException(e.getMessage());
        }
        catch (InvalidKeyException e) {
            log.error("[Herodotus] |- Minio catch InvalidKeyException in [{}].", (Object)function, (Object)e);
            throw new OssInvalidKeyException(e.getMessage());
        }
        catch (IOException e) {
            log.error("[Herodotus] |- Minio catch IOException in [{}].", (Object)function, (Object)e);
            if (e instanceof ConnectException) {
                throw new OssConnectException(e.getMessage());
            }
            throw new OssIOException(e.getMessage());
        }
        catch (InvalidCipherTextException e) {
            log.error("[Herodotus] |- Minio catch InvalidCipherTextException in [{}].", (Object)function, (Object)e);
            throw new OssInvalidCipherTextException(e.getMessage());
        }
        finally {
            this.close(minioAdminClient);
        }
    }

    public void deleteUser(@Nonnull String accessKey) {
        String function = "deleteUser";
        MinioAdminClient minioAdminClient = (MinioAdminClient)this.getClient();
        try {
            minioAdminClient.deleteUser(accessKey);
        }
        catch (NoSuchAlgorithmException e) {
            log.error("[Herodotus] |- Minio catch NoSuchAlgorithmException in [{}].", (Object)function, (Object)e);
            throw new OssNoSuchAlgorithmException(e.getMessage());
        }
        catch (InvalidKeyException e) {
            log.error("[Herodotus] |- Minio catch InvalidKeyException in [{}].", (Object)function, (Object)e);
            throw new OssInvalidKeyException(e.getMessage());
        }
        catch (IOException e) {
            log.error("[Herodotus] |- Minio catch IOException in [{}].", (Object)function, (Object)e);
            if (e instanceof ConnectException) {
                throw new OssConnectException(e.getMessage());
            }
            throw new OssIOException(e.getMessage());
        }
        finally {
            this.close(minioAdminClient);
        }
    }
}

