/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.dialect.minio.repository;

import cn.herodotus.oss.dialect.minio.converter.arguments.ArgumentsToDownloadObjectArgsConverter;
import cn.herodotus.oss.dialect.minio.converter.arguments.ArgumentsToGetObjectArgsConverter;
import cn.herodotus.oss.dialect.minio.converter.arguments.ArgumentsToGetPreSignedObjectUrlConverter;
import cn.herodotus.oss.dialect.minio.converter.arguments.ArgumentsToListObjectsArgsConverter;
import cn.herodotus.oss.dialect.minio.converter.arguments.ArgumentsToListObjectsV2ArgsConverter;
import cn.herodotus.oss.dialect.minio.converter.arguments.ArgumentsToPutObjectArgsConverter;
import cn.herodotus.oss.dialect.minio.converter.arguments.ArgumentsToRemoveObjectArgsConverter;
import cn.herodotus.oss.dialect.minio.converter.arguments.ArgumentsToRemoveObjectsArgsConverter;
import cn.herodotus.oss.dialect.minio.converter.arguments.ArgumentsToStatObjectArgsConverter;
import cn.herodotus.oss.dialect.minio.converter.arguments.ArgumentsToUploadObjectArgsConverter;
import cn.herodotus.oss.dialect.minio.converter.domain.GetObjectResponseToDomainConverter;
import cn.herodotus.oss.dialect.minio.converter.domain.IterableResultItemToDomainConverter;
import cn.herodotus.oss.dialect.minio.converter.domain.IterableResultItemV2ToDomainConverter;
import cn.herodotus.oss.dialect.minio.converter.domain.ObjectWriteResponseToPutObjectDomainConverter;
import cn.herodotus.oss.dialect.minio.converter.domain.ObjectWriteResponseToUploadObjectDomainConverter;
import cn.herodotus.oss.dialect.minio.converter.domain.ResultDeleteErrorToDomainConverter;
import cn.herodotus.oss.dialect.minio.converter.domain.StatObjectResponseToDomainConverter;
import cn.herodotus.oss.dialect.minio.service.MinioObjectService;
import cn.herodotus.oss.dialect.minio.utils.ConverterUtils;
import cn.herodotus.oss.specification.arguments.object.DeleteObjectArguments;
import cn.herodotus.oss.specification.arguments.object.DeleteObjectsArguments;
import cn.herodotus.oss.specification.arguments.object.DownloadObjectArguments;
import cn.herodotus.oss.specification.arguments.object.GeneratePresignedUrlArguments;
import cn.herodotus.oss.specification.arguments.object.GetObjectArguments;
import cn.herodotus.oss.specification.arguments.object.GetObjectMetadataArguments;
import cn.herodotus.oss.specification.arguments.object.ListObjectsArguments;
import cn.herodotus.oss.specification.arguments.object.ListObjectsV2Arguments;
import cn.herodotus.oss.specification.arguments.object.PutObjectArguments;
import cn.herodotus.oss.specification.arguments.object.UploadObjectArguments;
import cn.herodotus.oss.specification.core.repository.OssObjectRepository;
import cn.herodotus.oss.specification.domain.base.ObjectWriteDomain;
import cn.herodotus.oss.specification.domain.object.DeleteObjectDomain;
import cn.herodotus.oss.specification.domain.object.GetObjectDomain;
import cn.herodotus.oss.specification.domain.object.ListObjectsDomain;
import cn.herodotus.oss.specification.domain.object.ListObjectsV2Domain;
import cn.herodotus.oss.specification.domain.object.ObjectMetadataDomain;
import cn.herodotus.oss.specification.domain.object.PutObjectDomain;
import io.minio.DownloadObjectArgs;
import io.minio.GetObjectArgs;
import io.minio.GetObjectResponse;
import io.minio.GetPresignedObjectUrlArgs;
import io.minio.ListObjectsArgs;
import io.minio.ObjectWriteResponse;
import io.minio.PutObjectArgs;
import io.minio.RemoveObjectArgs;
import io.minio.RemoveObjectsArgs;
import io.minio.Result;
import io.minio.StatObjectArgs;
import io.minio.StatObjectResponse;
import io.minio.UploadObjectArgs;
import io.minio.messages.Item;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class MinioObjectRepository
implements OssObjectRepository {
    private static final Logger log = LoggerFactory.getLogger(MinioObjectRepository.class);
    private final MinioObjectService minioObjectService;

    public MinioObjectRepository(MinioObjectService minioObjectService) {
        this.minioObjectService = minioObjectService;
    }

    public ListObjectsDomain listObjects(ListObjectsArguments arguments) {
        ArgumentsToListObjectsArgsConverter toArgs = new ArgumentsToListObjectsArgsConverter();
        Iterable<Result<Item>> iterable = this.minioObjectService.listObjects((ListObjectsArgs)toArgs.convert(arguments));
        IterableResultItemToDomainConverter toDomain = new IterableResultItemToDomainConverter(arguments);
        return (ListObjectsDomain)toDomain.convert(iterable);
    }

    public ListObjectsV2Domain listObjectsV2(ListObjectsV2Arguments arguments) {
        ArgumentsToListObjectsV2ArgsConverter toArgs = new ArgumentsToListObjectsV2ArgsConverter();
        Iterable<Result<Item>> iterable = this.minioObjectService.listObjects((ListObjectsArgs)toArgs.convert(arguments));
        IterableResultItemV2ToDomainConverter toDomain = new IterableResultItemV2ToDomainConverter(arguments);
        return (ListObjectsV2Domain)toDomain.convert(iterable);
    }

    public void deleteObject(DeleteObjectArguments arguments) {
        ArgumentsToRemoveObjectArgsConverter toArgs = new ArgumentsToRemoveObjectArgsConverter();
        this.minioObjectService.removeObject((RemoveObjectArgs)toArgs.convert(arguments));
    }

    public List<DeleteObjectDomain> deleteObjects(DeleteObjectsArguments arguments) {
        ArgumentsToRemoveObjectsArgsConverter toArgs = new ArgumentsToRemoveObjectsArgsConverter();
        Iterable deletesErrors = this.minioObjectService.removeObjects((RemoveObjectsArgs)toArgs.convert(arguments));
        return ConverterUtils.toDomains(deletesErrors, new ResultDeleteErrorToDomainConverter());
    }

    public ObjectMetadataDomain getObjectMetadata(GetObjectMetadataArguments arguments) {
        ArgumentsToStatObjectArgsConverter toRequest = new ArgumentsToStatObjectArgsConverter();
        StatObjectResponseToDomainConverter toDomain = new StatObjectResponseToDomainConverter();
        StatObjectResponse response = this.minioObjectService.statObject((StatObjectArgs)toRequest.convert(arguments));
        return (ObjectMetadataDomain)toDomain.convert(response);
    }

    public GetObjectDomain getObject(GetObjectArguments arguments) {
        ArgumentsToGetObjectArgsConverter toRequest = new ArgumentsToGetObjectArgsConverter();
        GetObjectResponseToDomainConverter toDomain = new GetObjectResponseToDomainConverter();
        GetObjectResponse response = this.minioObjectService.getObject((GetObjectArgs)toRequest.convert(arguments));
        return (GetObjectDomain)toDomain.convert(response);
    }

    public PutObjectDomain putObject(PutObjectArguments arguments) {
        ArgumentsToPutObjectArgsConverter toRequest = new ArgumentsToPutObjectArgsConverter();
        ObjectWriteResponseToPutObjectDomainConverter toDomain = new ObjectWriteResponseToPutObjectDomainConverter();
        ObjectWriteResponse response = this.minioObjectService.putObject((PutObjectArgs)toRequest.convert(arguments));
        return (PutObjectDomain)toDomain.convert(response);
    }

    public String generatePresignedUrl(GeneratePresignedUrlArguments arguments) {
        ArgumentsToGetPreSignedObjectUrlConverter toRequest = new ArgumentsToGetPreSignedObjectUrlConverter();
        return this.minioObjectService.getPreSignedObjectUrl((GetPresignedObjectUrlArgs)toRequest.convert(arguments));
    }

    public ObjectMetadataDomain download(DownloadObjectArguments arguments) {
        ArgumentsToDownloadObjectArgsConverter toRequest = new ArgumentsToDownloadObjectArgsConverter();
        this.minioObjectService.downloadObject((DownloadObjectArgs)toRequest.convert(arguments));
        return new ObjectMetadataDomain();
    }

    public ObjectWriteDomain upload(UploadObjectArguments arguments) {
        ArgumentsToUploadObjectArgsConverter toRequest = new ArgumentsToUploadObjectArgsConverter();
        ObjectWriteResponseToUploadObjectDomainConverter toDomain = new ObjectWriteResponseToUploadObjectDomainConverter();
        ObjectWriteResponse response = this.minioObjectService.uploadObject((UploadObjectArgs)toRequest.convert(arguments));
        return (ObjectWriteDomain)toDomain.convert(response);
    }
}

