/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.dialect.minio.converter.domain;

import cn.herodotus.oss.specification.domain.bucket.BucketDomain;
import io.minio.messages.Bucket;
import java.util.Date;
import java.util.Optional;
import org.springframework.core.convert.converter.Converter;

public class BucketToDomainConverter
implements Converter<Bucket, BucketDomain> {
    public BucketDomain convert(Bucket source) {
        Optional<Bucket> optional = Optional.ofNullable(source);
        return optional.map(bucket -> {
            BucketDomain domain = new BucketDomain();
            domain.setBucketName(bucket.name());
            Optional.ofNullable(bucket.creationDate()).ifPresent(zonedDateTime -> domain.setCreationDate(new Date(zonedDateTime.toInstant().toEpochMilli())));
            return domain;
        }).orElse(null);
    }
}

