/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.dialect.aliyun.repository;

import cn.herodotus.engine.assistant.definition.support.AbstractObjectPool;
import cn.herodotus.oss.dialect.aliyun.converter.arguments.ArgumentsToDeleteObjectRequestConverter;
import cn.herodotus.oss.dialect.aliyun.converter.arguments.ArgumentsToDeleteObjectsRequestConverter;
import cn.herodotus.oss.dialect.aliyun.converter.arguments.ArgumentsToListObjectsRequestConverter;
import cn.herodotus.oss.dialect.aliyun.converter.arguments.ArgumentsToListObjectsV2RequestConverter;
import cn.herodotus.oss.dialect.aliyun.converter.domain.DeleteObjectsResultToDomainConverter;
import cn.herodotus.oss.dialect.aliyun.converter.domain.ListObjectsV2ResultToDomainConverter;
import cn.herodotus.oss.dialect.aliyun.converter.domain.ObjectListingToDomainConverter;
import cn.herodotus.oss.dialect.aliyun.definition.service.BaseAliyunService;
import cn.herodotus.oss.dialect.core.exception.OssExecutionException;
import cn.herodotus.oss.dialect.core.exception.OssServerException;
import cn.herodotus.oss.specification.arguments.object.DeleteObjectArguments;
import cn.herodotus.oss.specification.arguments.object.DeleteObjectsArguments;
import cn.herodotus.oss.specification.arguments.object.DownloadObjectArguments;
import cn.herodotus.oss.specification.arguments.object.GeneratePresignedUrlArguments;
import cn.herodotus.oss.specification.arguments.object.GetObjectArguments;
import cn.herodotus.oss.specification.arguments.object.GetObjectMetadataArguments;
import cn.herodotus.oss.specification.arguments.object.ListObjectsArguments;
import cn.herodotus.oss.specification.arguments.object.ListObjectsV2Arguments;
import cn.herodotus.oss.specification.arguments.object.PutObjectArguments;
import cn.herodotus.oss.specification.arguments.object.UploadObjectArguments;
import cn.herodotus.oss.specification.core.repository.OssObjectRepository;
import cn.herodotus.oss.specification.domain.base.ObjectWriteDomain;
import cn.herodotus.oss.specification.domain.object.DeleteObjectDomain;
import cn.herodotus.oss.specification.domain.object.GetObjectDomain;
import cn.herodotus.oss.specification.domain.object.ListObjectsDomain;
import cn.herodotus.oss.specification.domain.object.ListObjectsV2Domain;
import cn.herodotus.oss.specification.domain.object.ObjectMetadataDomain;
import cn.herodotus.oss.specification.domain.object.PutObjectDomain;
import com.aliyun.oss.ClientException;
import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.model.DeleteObjectsRequest;
import com.aliyun.oss.model.DeleteObjectsResult;
import com.aliyun.oss.model.GenericRequest;
import com.aliyun.oss.model.ListObjectsRequest;
import com.aliyun.oss.model.ListObjectsV2Request;
import com.aliyun.oss.model.ListObjectsV2Result;
import com.aliyun.oss.model.ObjectListing;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class AliyunObjectRepository
extends BaseAliyunService
implements OssObjectRepository {
    private static final Logger log = LoggerFactory.getLogger(AliyunObjectRepository.class);

    public AliyunObjectRepository(AbstractObjectPool<OSS> ossClientObjectPool) {
        super(ossClientObjectPool);
    }

    public ListObjectsDomain listObjects(ListObjectsArguments arguments) {
        String function = "listObjects";
        ArgumentsToListObjectsRequestConverter toArgs = new ArgumentsToListObjectsRequestConverter();
        ObjectListingToDomainConverter toDomain = new ObjectListingToDomainConverter();
        OSS client = (OSS)this.getClient();
        try {
            ObjectListing objectListing = client.listObjects((ListObjectsRequest)toArgs.convert(arguments));
            ListObjectsDomain listObjectsDomain = (ListObjectsDomain)toDomain.convert(objectListing);
            return listObjectsDomain;
        }
        catch (ClientException e) {
            log.error("[Herodotus] |- Aliyun OSS catch ClientException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        catch (OSSException e) {
            log.error("[Herodotus] |- Aliyun OSS catch OSSException in [{}].", (Object)function, (Object)e);
            throw new OssExecutionException(e.getMessage());
        }
        finally {
            this.close(client);
        }
    }

    public ListObjectsV2Domain listObjectsV2(ListObjectsV2Arguments arguments) {
        String function = "listObjectsV2";
        ArgumentsToListObjectsV2RequestConverter toArgs = new ArgumentsToListObjectsV2RequestConverter();
        ListObjectsV2ResultToDomainConverter toDomain = new ListObjectsV2ResultToDomainConverter();
        OSS client = (OSS)this.getClient();
        try {
            ListObjectsV2Result listObjectsV2Result = client.listObjectsV2((ListObjectsV2Request)toArgs.convert(arguments));
            ListObjectsV2Domain listObjectsV2Domain = (ListObjectsV2Domain)toDomain.convert(listObjectsV2Result);
            return listObjectsV2Domain;
        }
        catch (ClientException e) {
            log.error("[Herodotus] |- Aliyun OSS catch ClientException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        catch (OSSException e) {
            log.error("[Herodotus] |- Aliyun OSS catch OSSException in [{}].", (Object)function, (Object)e);
            throw new OssExecutionException(e.getMessage());
        }
        finally {
            this.close(client);
        }
    }

    public void deleteObject(DeleteObjectArguments arguments) {
        String function = "deleteObject";
        OSS client = (OSS)this.getClient();
        try {
            ArgumentsToDeleteObjectRequestConverter toArgs = new ArgumentsToDeleteObjectRequestConverter();
            client.deleteObject((GenericRequest)toArgs.convert(arguments));
        }
        catch (ClientException e) {
            log.error("[Herodotus] |- Aliyun OSS catch ClientException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        catch (OSSException e) {
            log.error("[Herodotus] |- Aliyun OSS catch OSSException in [{}].", (Object)function, (Object)e);
            throw new OssExecutionException(e.getMessage());
        }
        finally {
            this.close(client);
        }
    }

    public List<DeleteObjectDomain> deleteObjects(DeleteObjectsArguments arguments) {
        String function = "deleteObjects";
        OSS client = (OSS)this.getClient();
        try {
            ArgumentsToDeleteObjectsRequestConverter toArgs = new ArgumentsToDeleteObjectsRequestConverter();
            DeleteObjectsResultToDomainConverter toDomain = new DeleteObjectsResultToDomainConverter();
            DeleteObjectsResult result = client.deleteObjects((DeleteObjectsRequest)toArgs.convert(arguments));
            List list = (List)toDomain.convert(result);
            return list;
        }
        catch (ClientException e) {
            log.error("[Herodotus] |- Aliyun OSS catch ClientException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        catch (OSSException e) {
            log.error("[Herodotus] |- Aliyun OSS catch OSSException in [{}].", (Object)function, (Object)e);
            throw new OssExecutionException(e.getMessage());
        }
        finally {
            this.close(client);
        }
    }

    public ObjectMetadataDomain getObjectMetadata(GetObjectMetadataArguments arguments) {
        return null;
    }

    public GetObjectDomain getObject(GetObjectArguments arguments) {
        return null;
    }

    public PutObjectDomain putObject(PutObjectArguments arguments) {
        return null;
    }

    public String generatePresignedUrl(GeneratePresignedUrlArguments arguments) {
        return null;
    }

    public ObjectMetadataDomain download(DownloadObjectArguments arguments) {
        return null;
    }

    public ObjectWriteDomain upload(UploadObjectArguments arguments) {
        return null;
    }
}

