/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.dialect.aliyun.definition.pool;

import cn.herodotus.oss.dialect.aliyun.properties.AliyunProperties;
import cn.herodotus.oss.dialect.core.client.AbstractOssClientPooledObjectFactory;
import cn.herodotus.oss.dialect.core.properties.AbstractOssProperties;
import com.aliyun.oss.ClientBuilderConfiguration;
import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClientBuilder;
import com.aliyun.oss.common.auth.CredentialsProvider;
import com.aliyun.oss.common.auth.CredentialsProviderFactory;
import com.aliyun.oss.common.auth.STSAssumeRoleSessionCredentialsProvider;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.pool2.PooledObject;

public class AliyunClientPooledObjectFactory
extends AbstractOssClientPooledObjectFactory<OSS> {
    private final AliyunProperties aliyunProperties;

    public AliyunClientPooledObjectFactory(AliyunProperties aliyunProperties) {
        super((AbstractOssProperties)aliyunProperties);
        this.aliyunProperties = aliyunProperties;
    }

    public OSS create() throws Exception {
        STSAssumeRoleSessionCredentialsProvider credentialsProvider = CredentialsProviderFactory.newSTSAssumeRoleSessionCredentialsProvider((String)this.aliyunProperties.getRegion(), (String)this.aliyunProperties.getAccessKey(), (String)this.aliyunProperties.getSecretKey(), (String)this.aliyunProperties.getRole());
        ClientBuilderConfiguration configuration = new ClientBuilderConfiguration();
        return new OSSClientBuilder().build(this.aliyunProperties.getEndpoint(), (CredentialsProvider)credentialsProvider, configuration);
    }

    public void destroyObject(PooledObject<OSS> p) throws Exception {
        OSS client = (OSS)p.getObject();
        if (ObjectUtils.isNotEmpty((Object)client)) {
            client.shutdown();
        }
    }
}

