/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.dialect.aliyun.service;

import cn.herodotus.oss.dialect.aliyun.definition.service.BaseAliyunService;
import cn.herodotus.oss.dialect.core.exception.OssExecutionException;
import cn.herodotus.oss.dialect.core.exception.OssServerException;
import cn.herodotus.stirrup.kernel.definition.support.AbstractObjectPool;
import com.aliyun.oss.ClientException;
import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.model.GeneratePresignedUrlRequest;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class AliyunPresignedUrlService
extends BaseAliyunService {
    private static final Logger log = LoggerFactory.getLogger(AliyunPresignedUrlService.class);

    public AliyunPresignedUrlService(AbstractObjectPool<OSS> ossClientObjectPool) {
        super(ossClientObjectPool);
    }

    public URL generatePresignedUrl(GeneratePresignedUrlRequest request) {
        String function = "generatePresignedUrl";
        OSS client = (OSS)this.getClient();
        try {
            URL uRL = client.generatePresignedUrl(request);
            return uRL;
        }
        catch (ClientException e) {
            log.error("[Herodotus] |- Aliyun OSS catch ClientException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        catch (OSSException e) {
            log.error("[Herodotus] |- Aliyun OSS catch OSSException in [{}].", (Object)function, (Object)e);
            throw new OssExecutionException(e.getMessage());
        }
        finally {
            this.close(client);
        }
    }
}

