/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.dialect.aliyun.service;

import cn.herodotus.engine.assistant.core.definition.AbstractObjectPool;
import cn.herodotus.oss.dialect.aliyun.definition.service.BaseAliyunService;
import cn.herodotus.oss.dialect.core.exception.OssExecutionException;
import cn.herodotus.oss.dialect.core.exception.OssServerException;
import com.aliyun.oss.ClientException;
import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.model.GenericRequest;
import com.aliyun.oss.model.LifecycleRule;
import com.aliyun.oss.model.SetBucketLifecycleRequest;
import com.aliyun.oss.model.VoidResult;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class AliyunBucketLifecycleService
extends BaseAliyunService {
    private static final Logger log = LoggerFactory.getLogger(AliyunBucketLifecycleService.class);

    public AliyunBucketLifecycleService(AbstractObjectPool<OSS> ossClientObjectPool) {
        super(ossClientObjectPool);
    }

    public VoidResult setBucketLifecycle(SetBucketLifecycleRequest request) {
        String function = "setBucketLifecycle";
        OSS client = (OSS)this.getClient();
        try {
            VoidResult voidResult = client.setBucketLifecycle(request);
            return voidResult;
        }
        catch (ClientException e) {
            log.error("[Herodotus] |- Aliyun OSS catch ClientException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        catch (OSSException e) {
            log.error("[Herodotus] |- Aliyun OSS catch OSSException in [{}].", (Object)function, (Object)e);
            throw new OssExecutionException(e.getMessage());
        }
        finally {
            this.close(client);
        }
    }

    public List<LifecycleRule> getBucketLifecycle(GenericRequest request) {
        String function = "getBucketLifecycle";
        OSS client = (OSS)this.getClient();
        try {
            List list = client.getBucketLifecycle(request);
            return list;
        }
        catch (ClientException e) {
            log.error("[Herodotus] |- Aliyun OSS catch ClientException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        catch (OSSException e) {
            log.error("[Herodotus] |- Aliyun OSS catch OSSException in [{}].", (Object)function, (Object)e);
            throw new OssExecutionException(e.getMessage());
        }
        finally {
            this.close(client);
        }
    }

    public VoidResult deleteBucketLifecycle(GenericRequest request) {
        String function = "deleteBucketLifecycle";
        OSS client = (OSS)this.getClient();
        try {
            VoidResult voidResult = client.deleteBucketLifecycle(request);
            return voidResult;
        }
        catch (ClientException e) {
            log.error("[Herodotus] |- Aliyun OSS catch ClientException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        catch (OSSException e) {
            log.error("[Herodotus] |- Aliyun OSS catch OSSException in [{}].", (Object)function, (Object)e);
            throw new OssExecutionException(e.getMessage());
        }
        finally {
            this.close(client);
        }
    }
}

