/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.dialect.aliyun.service;

import cn.herodotus.engine.assistant.core.definition.AbstractObjectPool;
import cn.herodotus.oss.dialect.aliyun.definition.service.BaseAliyunService;
import cn.herodotus.oss.dialect.core.exception.OssExecutionException;
import cn.herodotus.oss.dialect.core.exception.OssServerException;
import com.aliyun.oss.ClientException;
import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.model.CORSConfiguration;
import com.aliyun.oss.model.GenericRequest;
import com.aliyun.oss.model.SetBucketCORSRequest;
import com.aliyun.oss.model.VoidResult;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class AliyunBucketCorsService
extends BaseAliyunService {
    private static final Logger log = LoggerFactory.getLogger(AliyunBucketCorsService.class);

    public AliyunBucketCorsService(AbstractObjectPool<OSS> ossClientObjectPool) {
        super(ossClientObjectPool);
    }

    public VoidResult setBucketCORS(SetBucketCORSRequest request) {
        String function = "setBucketCORS";
        OSS client = (OSS)this.getClient();
        try {
            VoidResult voidResult = client.setBucketCORS(request);
            return voidResult;
        }
        catch (ClientException e) {
            log.error("[Herodotus] |- Aliyun OSS catch ClientException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        catch (OSSException e) {
            log.error("[Herodotus] |- Aliyun OSS catch OSSException in [{}].", (Object)function, (Object)e);
            throw new OssExecutionException(e.getMessage());
        }
        finally {
            this.close(client);
        }
    }

    public CORSConfiguration getBucketCORS(GenericRequest request) {
        String function = "getBucketCORS";
        OSS client = (OSS)this.getClient();
        try {
            CORSConfiguration cORSConfiguration = client.getBucketCORS(request);
            return cORSConfiguration;
        }
        catch (ClientException e) {
            log.error("[Herodotus] |- Aliyun OSS catch ClientException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        catch (OSSException e) {
            log.error("[Herodotus] |- Aliyun OSS catch OSSException in [{}].", (Object)function, (Object)e);
            throw new OssExecutionException(e.getMessage());
        }
        finally {
            this.close(client);
        }
    }

    public List<SetBucketCORSRequest.CORSRule> getBucketCORSRules(GenericRequest request) {
        String function = "getBucketCORSRules";
        OSS client = (OSS)this.getClient();
        try {
            List list = client.getBucketCORSRules(request);
            return list;
        }
        catch (ClientException e) {
            log.error("[Herodotus] |- Aliyun OSS catch ClientException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        catch (OSSException e) {
            log.error("[Herodotus] |- Aliyun OSS catch OSSException in [{}].", (Object)function, (Object)e);
            throw new OssExecutionException(e.getMessage());
        }
        finally {
            this.close(client);
        }
    }

    public VoidResult deleteBucketCORSRules(GenericRequest request) {
        String function = "deleteBucketCORSRules";
        OSS client = (OSS)this.getClient();
        try {
            VoidResult voidResult = client.deleteBucketCORSRules(request);
            return voidResult;
        }
        catch (ClientException e) {
            log.error("[Herodotus] |- Aliyun OSS catch ClientException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        catch (OSSException e) {
            log.error("[Herodotus] |- Aliyun OSS catch OSSException in [{}].", (Object)function, (Object)e);
            throw new OssExecutionException(e.getMessage());
        }
        finally {
            this.close(client);
        }
    }
}

