/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.dialect.aliyun.configuration;

import cn.herodotus.oss.dialect.aliyun.definition.pool.AliyunClientObjectPool;
import cn.herodotus.oss.dialect.aliyun.definition.pool.AliyunClientPooledObjectFactory;
import cn.herodotus.oss.dialect.aliyun.properties.AliyunProperties;
import jakarta.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
public class AliyunClientConfiguration {
    private static final Logger log = LoggerFactory.getLogger(AliyunClientConfiguration.class);

    @PostConstruct
    public void postConstruct() {
        log.debug("[Herodotus] |- SDK [Aliyun Client] Auto Configure.");
    }

    @Bean
    @ConditionalOnMissingBean
    public AliyunClientObjectPool aliyunClientObjectPool(AliyunProperties aliyunProperties) {
        AliyunClientPooledObjectFactory factory = new AliyunClientPooledObjectFactory(aliyunProperties);
        AliyunClientObjectPool pool = new AliyunClientObjectPool(factory);
        log.trace("[Herodotus] |- Bean [Aliyun Client Pool] Auto Configure.");
        return pool;
    }
}

