/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.dialect.aliyun.repository;

import cn.herodotus.engine.assistant.core.definition.AbstractObjectPool;
import cn.herodotus.oss.dialect.aliyun.converter.arguments.ArgumentsToCreateBucketRequestConverter;
import cn.herodotus.oss.dialect.aliyun.converter.arguments.ArgumentsToDeleteBucketRequestConverter;
import cn.herodotus.oss.dialect.aliyun.converter.domain.BucketToDomainConverter;
import cn.herodotus.oss.dialect.aliyun.definition.service.BaseAliyunService;
import cn.herodotus.oss.dialect.core.exception.OssExecutionException;
import cn.herodotus.oss.dialect.core.exception.OssServerException;
import cn.herodotus.oss.dialect.core.utils.ConverterUtils;
import cn.herodotus.oss.specification.arguments.bucket.CreateBucketArguments;
import cn.herodotus.oss.specification.arguments.bucket.DeleteBucketArguments;
import cn.herodotus.oss.specification.core.repository.OssBucketRepository;
import cn.herodotus.oss.specification.domain.bucket.BucketDomain;
import com.aliyun.oss.ClientException;
import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.model.CreateBucketRequest;
import com.aliyun.oss.model.GenericRequest;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.convert.converter.Converter;
import org.springframework.stereotype.Service;

@Service
public class AliyunBucketRepository
extends BaseAliyunService
implements OssBucketRepository {
    private static final Logger log = LoggerFactory.getLogger(AliyunBucketRepository.class);

    public AliyunBucketRepository(AbstractObjectPool<OSS> ossClientObjectPool) {
        super(ossClientObjectPool);
    }

    public boolean doesBucketExist(String bucketName) {
        String function = "doesBucketExist";
        OSS client = (OSS)this.getClient();
        try {
            boolean bl = client.doesBucketExist(bucketName);
            return bl;
        }
        catch (ClientException e) {
            log.error("[Herodotus] |- Catch ClientException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        catch (OSSException e) {
            log.error("[Herodotus] |- Catch OSSException in [{}].", (Object)function, (Object)e);
            throw new OssExecutionException(e.getMessage());
        }
        finally {
            this.close(client);
        }
    }

    public List<BucketDomain> listBuckets() {
        String function = "listBuckets";
        OSS client = (OSS)this.getClient();
        try {
            List list = ConverterUtils.toDomains((List)client.listBuckets(), (Converter)new BucketToDomainConverter());
            return list;
        }
        catch (ClientException e) {
            log.error("[Herodotus] |- Aliyun OSS catch ClientException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        catch (OSSException e) {
            log.error("[Herodotus] |- Aliyun OSS catch OSSException in [{}].", (Object)function, (Object)e);
            throw new OssExecutionException(e.getMessage());
        }
        finally {
            this.close(client);
        }
    }

    public BucketDomain createBucket(String bucketName) {
        String function = "createBucket";
        OSS client = (OSS)this.getClient();
        try {
            BucketDomain bucketDomain = (BucketDomain)ConverterUtils.toDomain((Object)client.createBucket(bucketName), (Converter)new BucketToDomainConverter());
            return bucketDomain;
        }
        catch (ClientException e) {
            log.error("[Herodotus] |- Aliyun OSS catch ClientException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        catch (OSSException e) {
            log.error("[Herodotus] |- Aliyun OSS catch OSSException in [{}].", (Object)function, (Object)e);
            throw new OssExecutionException(e.getMessage());
        }
        finally {
            this.close(client);
        }
    }

    public BucketDomain createBucket(CreateBucketArguments arguments) {
        String function = "createBucket";
        OSS client = (OSS)this.getClient();
        try {
            ArgumentsToCreateBucketRequestConverter toRequest = new ArgumentsToCreateBucketRequestConverter();
            BucketDomain bucketDomain = (BucketDomain)ConverterUtils.toDomain((Object)client.createBucket((CreateBucketRequest)toRequest.convert(arguments)), (Converter)new BucketToDomainConverter());
            return bucketDomain;
        }
        catch (ClientException e) {
            log.error("[Herodotus] |- Aliyun OSS catch ClientException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        catch (OSSException e) {
            log.error("[Herodotus] |- Aliyun OSS catch OSSException in [{}].", (Object)function, (Object)e);
            throw new OssExecutionException(e.getMessage());
        }
        finally {
            this.close(client);
        }
    }

    public void deleteBucket(String bucketName) {
        String function = "deleteBucket";
        OSS client = (OSS)this.getClient();
        try {
            client.deleteBucket(bucketName);
        }
        catch (ClientException e) {
            log.error("[Herodotus] |- Aliyun OSS catch ClientException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        catch (OSSException e) {
            log.error("[Herodotus] |- Aliyun OSS catch OSSException in [{}].", (Object)function, (Object)e);
            throw new OssExecutionException(e.getMessage());
        }
        finally {
            this.close(client);
        }
    }

    public void deleteBucket(DeleteBucketArguments arguments) {
        String function = "deleteBucket";
        OSS client = (OSS)this.getClient();
        try {
            ArgumentsToDeleteBucketRequestConverter toRequest = new ArgumentsToDeleteBucketRequestConverter();
            client.deleteBucket((GenericRequest)toRequest.convert(arguments));
        }
        catch (ClientException e) {
            log.error("[Herodotus] |- Aliyun OSS catch ClientException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        catch (OSSException e) {
            log.error("[Herodotus] |- Aliyun OSS catch OSSException in [{}].", (Object)function, (Object)e);
            throw new OssExecutionException(e.getMessage());
        }
        finally {
            this.close(client);
        }
    }
}

