/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.dialect.aliyun.service;

import cn.herodotus.engine.assistant.core.definition.AbstractObjectPool;
import cn.herodotus.oss.dialect.aliyun.definition.service.BaseAliyunService;
import cn.herodotus.oss.dialect.core.exception.OssExecutionException;
import cn.herodotus.oss.dialect.core.exception.OssServerException;
import com.aliyun.oss.ClientException;
import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.model.GenericRequest;
import com.aliyun.oss.model.SetBucketStorageCapacityRequest;
import com.aliyun.oss.model.UserQos;
import com.aliyun.oss.model.VoidResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class AliyunBucketStorageCapacityService
extends BaseAliyunService {
    private static final Logger log = LoggerFactory.getLogger(AliyunBucketStorageCapacityService.class);

    public AliyunBucketStorageCapacityService(AbstractObjectPool<OSS> ossClientObjectPool) {
        super(ossClientObjectPool);
    }

    public VoidResult setBucketStorageCapacity(SetBucketStorageCapacityRequest request) {
        String function = "setBucketStorageCapacity";
        OSS client = (OSS)this.getClient();
        try {
            VoidResult voidResult = client.setBucketStorageCapacity(request);
            return voidResult;
        }
        catch (ClientException e) {
            log.error("[Herodotus] |- Aliyun OSS catch ClientException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        catch (OSSException e) {
            log.error("[Herodotus] |- Aliyun OSS catch OSSException in [{}].", (Object)function, (Object)e);
            throw new OssExecutionException(e.getMessage());
        }
        finally {
            this.close(client);
        }
    }

    public UserQos getBucketStorageCapacity(GenericRequest request) {
        String function = "getBucketStorageCapacity";
        OSS client = (OSS)this.getClient();
        try {
            UserQos userQos = client.getBucketStorageCapacity(request);
            return userQos;
        }
        catch (ClientException e) {
            log.error("[Herodotus] |- Aliyun OSS catch ClientException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        catch (OSSException e) {
            log.error("[Herodotus] |- Aliyun OSS catch OSSException in [{}].", (Object)function, (Object)e);
            throw new OssExecutionException(e.getMessage());
        }
        finally {
            this.close(client);
        }
    }
}

