/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.dialect.aliyun.service;

import cn.herodotus.oss.dialect.aliyun.definition.service.BaseAliyunService;
import cn.herodotus.oss.dialect.core.client.AbstractOssClientObjectPool;
import cn.herodotus.oss.dialect.core.exception.OssExecutionException;
import cn.herodotus.oss.dialect.core.exception.OssServerException;
import com.aliyun.oss.ClientException;
import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.model.CreateLiveChannelRequest;
import com.aliyun.oss.model.CreateLiveChannelResult;
import com.aliyun.oss.model.ListLiveChannelsRequest;
import com.aliyun.oss.model.LiveChannelGenericRequest;
import com.aliyun.oss.model.LiveChannelInfo;
import com.aliyun.oss.model.LiveChannelListing;
import com.aliyun.oss.model.LiveChannelStat;
import com.aliyun.oss.model.LiveRecord;
import com.aliyun.oss.model.SetLiveChannelRequest;
import com.aliyun.oss.model.VoidResult;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class AliyunLiveChannelService
extends BaseAliyunService {
    private static final Logger log = LoggerFactory.getLogger(AliyunLiveChannelService.class);

    public AliyunLiveChannelService(AbstractOssClientObjectPool<OSS> ossClientObjectPool) {
        super(ossClientObjectPool);
    }

    public CreateLiveChannelResult createLiveChannel(CreateLiveChannelRequest request) {
        String function = "createLiveChannel";
        OSS client = (OSS)this.getClient();
        try {
            CreateLiveChannelResult createLiveChannelResult = client.createLiveChannel(request);
            return createLiveChannelResult;
        }
        catch (ClientException e) {
            log.error("[Herodotus] |- Aliyun OSS catch ClientException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        catch (OSSException e) {
            log.error("[Herodotus] |- Aliyun OSS catch OSSException in [{}].", (Object)function, (Object)e);
            throw new OssExecutionException(e.getMessage());
        }
        finally {
            this.close(client);
        }
    }

    public VoidResult setLiveChannelStatus(SetLiveChannelRequest request) {
        String function = "setLiveChannelStatus";
        OSS client = (OSS)this.getClient();
        try {
            VoidResult voidResult = client.setLiveChannelStatus(request);
            return voidResult;
        }
        catch (ClientException e) {
            log.error("[Herodotus] |- Aliyun OSS catch ClientException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        catch (OSSException e) {
            log.error("[Herodotus] |- Aliyun OSS catch OSSException in [{}].", (Object)function, (Object)e);
            throw new OssExecutionException(e.getMessage());
        }
        finally {
            this.close(client);
        }
    }

    public LiveChannelInfo getLiveChannelInfo(LiveChannelGenericRequest request) {
        String function = "getLiveChannelInfo";
        OSS client = (OSS)this.getClient();
        try {
            LiveChannelInfo liveChannelInfo = client.getLiveChannelInfo(request);
            return liveChannelInfo;
        }
        catch (ClientException e) {
            log.error("[Herodotus] |- Aliyun OSS catch ClientException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        catch (OSSException e) {
            log.error("[Herodotus] |- Aliyun OSS catch OSSException in [{}].", (Object)function, (Object)e);
            throw new OssExecutionException(e.getMessage());
        }
        finally {
            this.close(client);
        }
    }

    public LiveChannelStat getLiveChannelStat(LiveChannelGenericRequest request) {
        String function = "getLiveChannelStat";
        OSS client = (OSS)this.getClient();
        try {
            LiveChannelStat liveChannelStat = client.getLiveChannelStat(request);
            return liveChannelStat;
        }
        catch (ClientException e) {
            log.error("[Herodotus] |- Aliyun OSS catch ClientException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        catch (OSSException e) {
            log.error("[Herodotus] |- Aliyun OSS catch OSSException in [{}].", (Object)function, (Object)e);
            throw new OssExecutionException(e.getMessage());
        }
        finally {
            this.close(client);
        }
    }

    public VoidResult deleteLiveChannel(LiveChannelGenericRequest request) {
        String function = "deleteLiveChannel";
        OSS client = (OSS)this.getClient();
        try {
            VoidResult voidResult = client.deleteLiveChannel(request);
            return voidResult;
        }
        catch (ClientException e) {
            log.error("[Herodotus] |- Aliyun OSS catch ClientException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        catch (OSSException e) {
            log.error("[Herodotus] |- Aliyun OSS catch OSSException in [{}].", (Object)function, (Object)e);
            throw new OssExecutionException(e.getMessage());
        }
        finally {
            this.close(client);
        }
    }

    public LiveChannelListing listLiveChannels(ListLiveChannelsRequest request) {
        String function = "listLiveChannels";
        OSS client = (OSS)this.getClient();
        try {
            LiveChannelListing liveChannelListing = client.listLiveChannels(request);
            return liveChannelListing;
        }
        catch (ClientException e) {
            log.error("[Herodotus] |- Aliyun OSS catch ClientException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        catch (OSSException e) {
            log.error("[Herodotus] |- Aliyun OSS catch OSSException in [{}].", (Object)function, (Object)e);
            throw new OssExecutionException(e.getMessage());
        }
        finally {
            this.close(client);
        }
    }

    public List<LiveRecord> getLiveChannelHistory(LiveChannelGenericRequest request) {
        String function = "getLiveChannelHistory";
        OSS client = (OSS)this.getClient();
        try {
            List list = client.getLiveChannelHistory(request);
            return list;
        }
        catch (ClientException e) {
            log.error("[Herodotus] |- Aliyun OSS catch ClientException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        catch (OSSException e) {
            log.error("[Herodotus] |- Aliyun OSS catch OSSException in [{}].", (Object)function, (Object)e);
            throw new OssExecutionException(e.getMessage());
        }
        finally {
            this.close(client);
        }
    }
}

