/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.dialect.aliyun.service;

import cn.herodotus.oss.dialect.aliyun.definition.service.BaseAliyunService;
import cn.herodotus.oss.dialect.core.client.AbstractOssClientObjectPool;
import cn.herodotus.oss.dialect.core.exception.OssIOException;
import com.aliyun.oss.OSS;
import com.aliyun.oss.model.DownloadFileRequest;
import com.aliyun.oss.model.DownloadFileResult;
import com.aliyun.oss.model.UploadFileRequest;
import com.aliyun.oss.model.UploadFileResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class AliyunFileService
extends BaseAliyunService {
    private static final Logger log = LoggerFactory.getLogger(AliyunFileService.class);

    public AliyunFileService(AbstractOssClientObjectPool<OSS> ossClientObjectPool) {
        super(ossClientObjectPool);
    }

    public UploadFileResult uploadFile(UploadFileRequest request) {
        String function = "uploadFile";
        OSS client = (OSS)this.getClient();
        try {
            UploadFileResult uploadFileResult = client.uploadFile(request);
            return uploadFileResult;
        }
        catch (Throwable e) {
            log.error("[Herodotus] |- Aliyun OSS catch Throwable in [{}].", (Object)function, (Object)e);
            throw new OssIOException(e.getMessage());
        }
        finally {
            this.close(client);
        }
    }

    public DownloadFileResult downloadFile(DownloadFileRequest request) {
        String function = "downloadFile";
        OSS client = (OSS)this.getClient();
        try {
            DownloadFileResult downloadFileResult = client.downloadFile(request);
            return downloadFileResult;
        }
        catch (Throwable e) {
            log.error("[Herodotus] |- Aliyun OSS catch Throwable in [{}].", (Object)function, (Object)e);
            throw new OssIOException(e.getMessage());
        }
        finally {
            this.close(client);
        }
    }
}

