/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.dialect.aliyun.service;

import cn.herodotus.oss.dialect.aliyun.definition.service.BaseAliyunService;
import cn.herodotus.oss.dialect.core.client.AbstractOssClientObjectPool;
import cn.herodotus.oss.dialect.core.exception.OssExecutionException;
import cn.herodotus.oss.dialect.core.exception.OssServerException;
import com.aliyun.oss.ClientException;
import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.model.CompleteBucketWormRequest;
import com.aliyun.oss.model.ExtendBucketWormRequest;
import com.aliyun.oss.model.GenericRequest;
import com.aliyun.oss.model.GetBucketWormResult;
import com.aliyun.oss.model.InitiateBucketWormRequest;
import com.aliyun.oss.model.InitiateBucketWormResult;
import com.aliyun.oss.model.VoidResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class AliyunBucketWormService
extends BaseAliyunService {
    private static final Logger log = LoggerFactory.getLogger(AliyunBucketWormService.class);

    public AliyunBucketWormService(AbstractOssClientObjectPool<OSS> ossClientObjectPool) {
        super(ossClientObjectPool);
    }

    public InitiateBucketWormResult initiateBucketWorm(InitiateBucketWormRequest request) {
        String function = "initiateBucketWorm";
        OSS client = (OSS)this.getClient();
        try {
            InitiateBucketWormResult initiateBucketWormResult = client.initiateBucketWorm(request);
            return initiateBucketWormResult;
        }
        catch (ClientException e) {
            log.error("[Herodotus] |- Aliyun OSS catch ClientException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        catch (OSSException e) {
            log.error("[Herodotus] |- Aliyun OSS catch OSSException in [{}].", (Object)function, (Object)e);
            throw new OssExecutionException(e.getMessage());
        }
        finally {
            this.close(client);
        }
    }

    public VoidResult abortBucketWorm(GenericRequest request) {
        String function = "abortBucketWorm";
        OSS client = (OSS)this.getClient();
        try {
            VoidResult voidResult = client.abortBucketWorm(request);
            return voidResult;
        }
        catch (ClientException e) {
            log.error("[Herodotus] |- Aliyun OSS catch ClientException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        catch (OSSException e) {
            log.error("[Herodotus] |- Aliyun OSS catch OSSException in [{}].", (Object)function, (Object)e);
            throw new OssExecutionException(e.getMessage());
        }
        finally {
            this.close(client);
        }
    }

    public VoidResult completeBucketWorm(CompleteBucketWormRequest request) {
        String function = "completeBucketWorm";
        OSS client = (OSS)this.getClient();
        try {
            VoidResult voidResult = client.completeBucketWorm(request);
            return voidResult;
        }
        catch (ClientException e) {
            log.error("[Herodotus] |- Aliyun OSS catch ClientException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        catch (OSSException e) {
            log.error("[Herodotus] |- Aliyun OSS catch OSSException in [{}].", (Object)function, (Object)e);
            throw new OssExecutionException(e.getMessage());
        }
        finally {
            this.close(client);
        }
    }

    public VoidResult extendBucketWorm(ExtendBucketWormRequest request) {
        String function = "extendBucketWorm";
        OSS client = (OSS)this.getClient();
        try {
            VoidResult voidResult = client.extendBucketWorm(request);
            return voidResult;
        }
        catch (ClientException e) {
            log.error("[Herodotus] |- Aliyun OSS catch ClientException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        catch (OSSException e) {
            log.error("[Herodotus] |- Aliyun OSS catch OSSException in [{}].", (Object)function, (Object)e);
            throw new OssExecutionException(e.getMessage());
        }
        finally {
            this.close(client);
        }
    }

    public GetBucketWormResult getBucketWorm(GenericRequest request) {
        String function = "getBucketWorm";
        OSS client = (OSS)this.getClient();
        try {
            GetBucketWormResult getBucketWormResult = client.getBucketWorm(request);
            return getBucketWormResult;
        }
        catch (ClientException e) {
            log.error("[Herodotus] |- Aliyun OSS catch ClientException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        catch (OSSException e) {
            log.error("[Herodotus] |- Aliyun OSS catch OSSException in [{}].", (Object)function, (Object)e);
            throw new OssExecutionException(e.getMessage());
        }
        finally {
            this.close(client);
        }
    }
}

