/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.dialect.aliyun.service;

import cn.herodotus.oss.dialect.aliyun.definition.service.BaseAliyunService;
import cn.herodotus.oss.dialect.core.client.AbstractOssClientObjectPool;
import cn.herodotus.oss.dialect.core.exception.OssExecutionException;
import cn.herodotus.oss.dialect.core.exception.OssServerException;
import com.aliyun.oss.ClientException;
import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.model.CreateBucketVpcipRequest;
import com.aliyun.oss.model.DeleteBucketVpcipRequest;
import com.aliyun.oss.model.GenericRequest;
import com.aliyun.oss.model.VoidResult;
import com.aliyun.oss.model.VpcPolicy;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class AliyunBucketVpcipService
extends BaseAliyunService {
    private static final Logger log = LoggerFactory.getLogger(AliyunBucketVpcipService.class);

    public AliyunBucketVpcipService(AbstractOssClientObjectPool<OSS> ossClientObjectPool) {
        super(ossClientObjectPool);
    }

    public VoidResult createBucketVpcip(CreateBucketVpcipRequest request) {
        String function = "createBucketVpcip";
        OSS client = (OSS)this.getClient();
        try {
            VoidResult voidResult = client.createBucketVpcip(request);
            return voidResult;
        }
        catch (ClientException e) {
            log.error("[Herodotus] |- Aliyun OSS catch ClientException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        catch (OSSException e) {
            log.error("[Herodotus] |- Aliyun OSS catch OSSException in [{}].", (Object)function, (Object)e);
            throw new OssExecutionException(e.getMessage());
        }
        finally {
            this.close(client);
        }
    }

    public List<VpcPolicy> getBucketVpcip(GenericRequest request) {
        String function = "getBucketVpcip";
        OSS client = (OSS)this.getClient();
        try {
            List list = client.getBucketVpcip(request);
            return list;
        }
        catch (ClientException e) {
            log.error("[Herodotus] |- Aliyun OSS catch ClientException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        catch (OSSException e) {
            log.error("[Herodotus] |- Aliyun OSS catch OSSException in [{}].", (Object)function, (Object)e);
            throw new OssExecutionException(e.getMessage());
        }
        finally {
            this.close(client);
        }
    }

    public VoidResult deleteBucketVpcip(DeleteBucketVpcipRequest request) {
        String function = "deleteBucketVpcip";
        OSS client = (OSS)this.getClient();
        try {
            VoidResult voidResult = client.deleteBucketVpcip(request);
            return voidResult;
        }
        catch (ClientException e) {
            log.error("[Herodotus] |- Aliyun OSS catch ClientException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        catch (OSSException e) {
            log.error("[Herodotus] |- Aliyun OSS catch OSSException in [{}].", (Object)function, (Object)e);
            throw new OssExecutionException(e.getMessage());
        }
        finally {
            this.close(client);
        }
    }
}

