/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.oss.dialect.aliyun.service;

import cn.herodotus.oss.dialect.aliyun.definition.service.BaseAliyunService;
import cn.herodotus.oss.dialect.core.client.AbstractOssClientObjectPool;
import cn.herodotus.oss.dialect.core.exception.OssExecutionException;
import cn.herodotus.oss.dialect.core.exception.OssServerException;
import com.aliyun.oss.ClientException;
import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.model.CreateSymlinkRequest;
import com.aliyun.oss.model.DescribeRegionsRequest;
import com.aliyun.oss.model.DescribeRegionsResult;
import com.aliyun.oss.model.GenerateRtmpUriRequest;
import com.aliyun.oss.model.GenerateVodPlaylistRequest;
import com.aliyun.oss.model.GenericRequest;
import com.aliyun.oss.model.GetVodPlaylistRequest;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.OSSSymlink;
import com.aliyun.oss.model.VoidResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class AliyunFunctionService
extends BaseAliyunService {
    private static final Logger log = LoggerFactory.getLogger(AliyunFunctionService.class);

    public AliyunFunctionService(AbstractOssClientObjectPool<OSS> ossClientObjectPool) {
        super(ossClientObjectPool);
    }

    public DescribeRegionsResult describeRegions(DescribeRegionsRequest request) {
        String function = "describeRegions";
        OSS client = (OSS)this.getClient();
        try {
            DescribeRegionsResult describeRegionsResult = client.describeRegions(request);
            return describeRegionsResult;
        }
        catch (ClientException e) {
            log.error("[Herodotus] |- Aliyun OSS catch ClientException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        catch (OSSException e) {
            log.error("[Herodotus] |- Aliyun OSS catch OSSException in [{}].", (Object)function, (Object)e);
            throw new OssExecutionException(e.getMessage());
        }
        finally {
            this.close(client);
        }
    }

    public String generateRtmpUri(GenerateRtmpUriRequest request) {
        String function = "generateRtmpUri";
        OSS client = (OSS)this.getClient();
        try {
            String string = client.generateRtmpUri(request);
            return string;
        }
        catch (ClientException e) {
            log.error("[Herodotus] |- Aliyun OSS catch ClientException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        catch (OSSException e) {
            log.error("[Herodotus] |- Aliyun OSS catch OSSException in [{}].", (Object)function, (Object)e);
            throw new OssExecutionException(e.getMessage());
        }
        finally {
            this.close(client);
        }
    }

    public VoidResult createSymlink(CreateSymlinkRequest request) {
        String function = "createSymlink";
        OSS client = (OSS)this.getClient();
        try {
            VoidResult voidResult = client.createSymlink(request);
            return voidResult;
        }
        catch (ClientException e) {
            log.error("[Herodotus] |- Aliyun OSS catch ClientException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        catch (OSSException e) {
            log.error("[Herodotus] |- Aliyun OSS catch OSSException in [{}].", (Object)function, (Object)e);
            throw new OssExecutionException(e.getMessage());
        }
        finally {
            this.close(client);
        }
    }

    public OSSSymlink getSymlink(GenericRequest request) {
        String function = "getSymlink";
        OSS client = (OSS)this.getClient();
        try {
            OSSSymlink oSSSymlink = client.getSymlink(request);
            return oSSSymlink;
        }
        catch (ClientException e) {
            log.error("[Herodotus] |- Aliyun OSS catch ClientException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        catch (OSSException e) {
            log.error("[Herodotus] |- Aliyun OSS catch OSSException in [{}].", (Object)function, (Object)e);
            throw new OssExecutionException(e.getMessage());
        }
        finally {
            this.close(client);
        }
    }

    public VoidResult generateVodPlaylist(GenerateVodPlaylistRequest request) {
        String function = "generateVodPlaylist";
        OSS client = (OSS)this.getClient();
        try {
            VoidResult voidResult = client.generateVodPlaylist(request);
            return voidResult;
        }
        catch (ClientException e) {
            log.error("[Herodotus] |- Aliyun OSS catch ClientException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        catch (OSSException e) {
            log.error("[Herodotus] |- Aliyun OSS catch OSSException in [{}].", (Object)function, (Object)e);
            throw new OssExecutionException(e.getMessage());
        }
        finally {
            this.close(client);
        }
    }

    public OSSObject getVodPlaylist(GetVodPlaylistRequest request) {
        String function = "getVodPlaylist";
        OSS client = (OSS)this.getClient();
        try {
            OSSObject oSSObject = client.getVodPlaylist(request);
            return oSSObject;
        }
        catch (ClientException e) {
            log.error("[Herodotus] |- Aliyun OSS catch ClientException in [{}].", (Object)function, (Object)e);
            throw new OssServerException(e.getMessage());
        }
        catch (OSSException e) {
            log.error("[Herodotus] |- Aliyun OSS catch OSSException in [{}].", (Object)function, (Object)e);
            throw new OssExecutionException(e.getMessage());
        }
        finally {
            this.close(client);
        }
    }
}

